/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.listedit;

import com.google.gwt.event.dom.client.ClickEvent;
import com.google.gwt.event.dom.client.ClickHandler;
import com.google.gwt.resources.client.ImageResource;
import com.google.gwt.user.client.ui.Grid;
import com.google.gwt.user.client.ui.HTMLTable;
import com.google.gwt.user.client.ui.Image;
import com.google.gwt.user.client.ui.PushButton;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.controls.listedit.ListEditorUi;
import java.util.Iterator;

public abstract class ExpandedListEditorUi<ValueType>
extends ListEditorUi<ValueType> {
    private final ImageResource removeImage;
    protected Grid expandedValuesGrid;
    private final boolean canRemoveItems;

    public ExpandedListEditorUi(StringMessages stringMessages, ImageResource removeImage, boolean canRemoveItems) {
        super(stringMessages);
        this.removeImage = removeImage;
        this.canRemoveItems = canRemoveItems;
    }

    protected abstract Widget createAddWidget();

    protected abstract Widget createValueWidget(int var1, ValueType var2);

    @Override
    public Widget initWidget() {
        this.expandedValuesGrid = new Grid(0, 2);
        this.expandedValuesGrid.ensureDebugId("ExpandedValuesGrid");
        VerticalPanel panel = new VerticalPanel();
        panel.add(this.createAddWidget());
        panel.add((Widget)this.expandedValuesGrid);
        return panel;
    }

    @Override
    public void refresh() {
        this.expandedValuesGrid.clear();
        int i = this.expandedValuesGrid.getRowCount() - 1;
        while (i >= 0) {
            this.expandedValuesGrid.removeRow(i);
            --i;
        }
        Iterator iterator = this.context.getValue().iterator();
        while (iterator.hasNext()) {
            Object value = iterator.next();
            this.addRow(value);
        }
    }

    protected void addRow(ValueType newValue) {
        int rowIndex = this.expandedValuesGrid.insertRow(this.expandedValuesGrid.getRowCount());
        if (this.canRemoveItems) {
            PushButton removeButton = new PushButton(new Image(this.removeImage));
            removeButton.ensureDebugId("RemoveButton");
            removeButton.setTitle(this.getStringMessages().remove());
            removeButton.addClickHandler(new ClickHandler(){

                public void onClick(ClickEvent event) {
                    HTMLTable.Cell cellForEvent = ExpandedListEditorUi.this.expandedValuesGrid.getCellForEvent(event);
                    int rowToRemove = cellForEvent.getRowIndex();
                    ExpandedListEditorUi.this.removeRow(rowToRemove);
                }
            });
            this.expandedValuesGrid.setWidget(rowIndex, 1, (Widget)removeButton);
        }
        this.expandedValuesGrid.setWidget(rowIndex, 0, this.createValueWidget(rowIndex, newValue));
    }

    private void removeRow(int rowIndexToRemove) {
        this.expandedValuesGrid.removeRow(rowIndexToRemove);
        this.context.getValue().remove(rowIndexToRemove);
        this.context.onChange();
        this.onRowRemoved(rowIndexToRemove);
    }

    protected void setValueFromValueWidget(Widget valueWidget, ValueType newValue, boolean fireEvents) {
        int i = 0;
        while (i < this.expandedValuesGrid.getRowCount()) {
            Widget gridWidget = this.expandedValuesGrid.getWidget(i, 0);
            if (gridWidget.getElement() == valueWidget.getElement()) {
                this.context.getValue().set(i, newValue);
                if (!fireEvents) break;
                this.context.onChange();
                break;
            }
            ++i;
        }
    }

    protected void addValue(ValueType newValue) {
        this.context.getValue().add(newValue);
        this.addRow(newValue);
        this.context.onChange();
        this.onRowAdded();
    }

    @Override
    public void onRowAdded() {
    }

    @Override
    public void onRowRemoved(int rowIndex) {
    }
}

