/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls.datetime;

import com.google.gwt.event.logical.shared.HasValueChangeHandlers;
import com.google.gwt.event.logical.shared.ValueChangeEvent;
import com.google.gwt.event.logical.shared.ValueChangeHandler;
import com.google.gwt.event.shared.EventHandler;
import com.google.gwt.event.shared.HandlerRegistration;
import com.google.gwt.i18n.client.DateTimeFormat;
import com.google.gwt.user.client.ui.FlowPanel;
import com.google.gwt.user.client.ui.Widget;
import com.sap.sse.gwt.client.controls.datetime.AbstractInput;
import com.sap.sse.gwt.client.controls.datetime.DateInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInput;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputResources;
import com.sap.sse.gwt.client.controls.datetime.DateTimeInputType;
import com.sap.sse.gwt.client.controls.datetime.NativeDateTimeInput;
import com.sap.sse.gwt.client.controls.datetime.TimeInput;
import java.util.ArrayList;
import java.util.Date;
import java.util.Objects;

public class DateAndTimeInput
extends AbstractInput {
    public DateAndTimeInput(DateTimeInput.Accuracy accuracy) {
        super(DateTimeInputType.DATETIME_LOCAL.isSupported() ? NativeDateTimeInput.datetimeLocale(accuracy) : new DateAndTimePanel(accuracy));
    }

    private static class DateAndTimePanel
    extends FlowPanel
    implements DateTimeInput {
        private final DateInput dateInput = new DateInput();
        private final TimeInput timeInput;
        private final DateTimeFormat dateFormat;
        private final DateTimeFormat timeFormat;
        private final DateTimeFormat datetimeFormat;

        private DateAndTimePanel(DateTimeInput.Accuracy accuracy) {
            this.add((Widget)this.dateInput);
            this.timeInput = new TimeInput(accuracy);
            this.add((Widget)this.timeInput);
            this.dateInput.addStyleName(DateTimeInputResources.INSTANCE.css().dateTimeInput());
            this.timeInput.addStyleName(DateTimeInputResources.INSTANCE.css().dateTimeInput());
            this.dateFormat = DateTimeInput.Accuracy.getDateFormat();
            this.timeFormat = accuracy.getTimeFormat();
            this.datetimeFormat = accuracy.getDatetimeFormat();
        }

        protected void onEnsureDebugId(String baseId) {
            super.onEnsureDebugId(baseId);
            this.dateInput.ensureDebugId("dateInput");
            this.timeInput.ensureDebugId("timeInput");
        }

        public HandlerRegistration addValueChangeHandler(ValueChangeHandler<Date> handler) {
            ValueChangeHandler internalHandler = event -> ValueChangeEvent.fire((HasValueChangeHandlers)this, (Object)this.getValue());
            ArrayList<HandlerRegistration> handlerRegistrations = new ArrayList<HandlerRegistration>();
            handlerRegistrations.add(this.dateInput.addValueChangeHandler((ValueChangeHandler<Date>)internalHandler));
            handlerRegistrations.add(this.timeInput.addValueChangeHandler((ValueChangeHandler<Date>)internalHandler));
            handlerRegistrations.add(this.addHandler((EventHandler)handler, ValueChangeEvent.getType()));
            return () -> handlerRegistrations.forEach(com.google.web.bindery.event.shared.HandlerRegistration::removeHandler);
        }

        public Date getValue() {
            Date dateValue = this.dateInput.getValue();
            Date timeValue = this.timeInput.getValue();
            if (Objects.nonNull(dateValue) && Objects.nonNull(timeValue)) {
                String dateString = this.dateFormat.format(this.dateInput.getValue());
                String timeString = this.timeFormat.format(this.timeInput.getValue());
                String dateAndTimeString = String.valueOf(dateString) + "T" + timeString;
                return this.datetimeFormat.parse(dateAndTimeString);
            }
            return null;
        }

        public void setValue(Date value) {
            this.dateInput.setValue(value);
            this.timeInput.setValue(value);
        }
    }
}

