/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.controls;

import com.google.gwt.user.client.TakesValue;
import com.google.gwt.user.client.ui.ListBox;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class GenericListBox<T>
extends ListBox
implements TakesValue<T> {
    private final List<T> items;
    private final ValueBuilder<T> valueBuilder;

    public GenericListBox(List<T> items, ValueBuilder<T> valueBuilder) {
        this.items = new ArrayList<T>(items);
        this.valueBuilder = valueBuilder;
    }

    public GenericListBox(ValueBuilder<T> valueBuilder) {
        this(Collections.emptyList(), valueBuilder);
    }

    public void addItem(T item) {
        this.items.add(item);
        this.addItem(this.valueBuilder.getValue(item));
    }

    public void addItems(Collection<T> items) {
        for (T item : items) {
            this.addItem(item);
        }
    }

    public void setValue(T value) {
        int i = this.items.indexOf(value);
        if (i > -1) {
            this.setSelectedIndex(i);
        }
    }

    public void setValues(List<T> values) {
        int i = 0;
        for (T item : this.items) {
            this.setItemSelected(i++, values.contains(item));
        }
    }

    public T getValue() {
        int i = this.getSelectedIndex();
        if (i < 0) {
            return null;
        }
        return this.items.get(i);
    }

    public ArrayList<T> getValues() {
        ArrayList<T> result = new ArrayList<T>();
        int i = 0;
        for (T item : this.items) {
            if (!this.isItemSelected(i++)) continue;
            result.add(item);
        }
        return result;
    }

    public void setItemSelected(int index, boolean selected) {
        super.setItemSelected(index, selected);
    }

    @FunctionalInterface
    public static interface ValueBuilder<T> {
        public String getValue(T var1);
    }
}

