/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.core.client.GWT;
import com.google.gwt.user.cellview.client.CellTable;
import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.SimplePager;
import com.google.gwt.user.cellview.client.TextColumn;
import com.google.gwt.user.client.ui.IsWidget;
import com.google.gwt.user.client.ui.VerticalPanel;
import com.google.gwt.user.client.ui.Widget;
import com.google.gwt.view.client.CellPreviewEvent;
import com.google.gwt.view.client.HasRows;
import com.google.gwt.view.client.ListDataProvider;
import com.google.gwt.view.client.MultiSelectionModel;
import com.google.gwt.view.client.Range;
import com.google.gwt.view.client.SelectionModel;
import com.sap.sse.common.Util;
import com.sap.sse.common.util.NaturalComparator;
import com.sap.sse.gwt.client.ErrorReporter;
import com.sap.sse.gwt.client.StringMessages;
import com.sap.sse.gwt.client.celltable.CellTableWithCheckboxResources;
import com.sap.sse.gwt.client.celltable.EntityIdentityComparator;
import com.sap.sse.gwt.client.celltable.FlushableCellTable;
import com.sap.sse.gwt.client.celltable.RefreshableMultiSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSelectionModel;
import com.sap.sse.gwt.client.celltable.RefreshableSingleSelectionModel;
import com.sap.sse.gwt.client.celltable.SelectionCheckboxColumn;
import java.util.Collection;
import java.util.Comparator;
import java.util.function.Function;

public abstract class TableWrapper<T, S extends RefreshableSelectionModel<T>, SM extends StringMessages, TR extends CellTableWithCheckboxResources>
implements IsWidget {
    private static final int PAGING_SIZE = 100;
    protected final FlushableCellTable<T> table;
    private S selectionModel;
    protected ListDataProvider<T> dataProvider;
    protected VerticalPanel mainPanel;
    protected final ErrorReporter errorReporter;
    private final SM stringMessages;
    private final boolean multiSelection;
    private SelectionCheckboxColumn<T> selectionCheckboxColumn;
    private final EntityIdentityComparator<T> entityIdentityComparator;
    private final TR tableRes;
    private final ColumnSortEvent.ListHandler<T> columnSortHandler;

    public Widget asWidget() {
        return this.mainPanel;
    }

    public TableWrapper(SM stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, EntityIdentityComparator<T> entityIdentityComparator) {
        this(stringMessages, errorReporter, multiSelection, enablePager, entityIdentityComparator, (CellTableWithCheckboxResources)GWT.create(CellTableWithCheckboxResources.class));
    }

    public TableWrapper(SM stringMessages, ErrorReporter errorReporter, boolean multiSelection, boolean enablePager, EntityIdentityComparator<T> entityIdentityComparator, TR tableRes) {
        this.entityIdentityComparator = entityIdentityComparator;
        this.multiSelection = multiSelection;
        this.errorReporter = errorReporter;
        this.stringMessages = stringMessages;
        this.tableRes = tableRes;
        this.table = new FlushableCellTable(10000, (CellTable.Resources)tableRes);
        this.table.ensureDebugId("WrappedTable");
        this.dataProvider = new ListDataProvider();
        this.columnSortHandler = new ColumnSortEvent.ListHandler(this.dataProvider.getList());
        this.table.addColumnSortHandler((ColumnSortEvent.Handler)this.columnSortHandler);
        this.registerSelectionModelOnNewDataProvider(this.dataProvider);
        this.mainPanel = new VerticalPanel();
        this.dataProvider.addDataDisplay(this.table);
        this.mainPanel.add(this.table);
        if (enablePager) {
            this.table.setPageSize(100);
            SimplePager pager = new SimplePager((StringMessages)stringMessages){
                private final /* synthetic */ StringMessages val$stringMessages;
                {
                    this.val$stringMessages = stringMessages;
                }

                protected String createText() {
                    HasRows display = this.getDisplay();
                    Range range = display.getVisibleRange();
                    int pageStart = range.getStart() + 1;
                    int pageSize = range.getLength();
                    int dataSize = display.getRowCount();
                    int endIndex = Math.min(dataSize, pageStart + pageSize - 1);
                    endIndex = Math.max(pageStart, endIndex);
                    boolean exact = display.isRowCountExact();
                    return this.val$stringMessages.pagerStateInfo(pageStart, endIndex, dataSize, exact);
                }
            };
            pager.setDisplay(this.table);
            this.mainPanel.add((Widget)pager);
        }
    }

    public ColumnSortEvent.ListHandler<T> getColumnSortHandler() {
        return this.columnSortHandler;
    }

    public FlushableCellTable<T> getTable() {
        return this.table;
    }

    public void addColumn(Column<T, ?> column) {
        this.table.addColumn(column);
    }

    public void addColumn(Column<T, ?> column, String header) {
        this.table.addColumn(column, header);
    }

    public void addColumnWithNaturalComparatorOnStringRepresentation(Column<T, ?> column, String header) {
        this.addColumn(column, header, (t1, t2) -> new NaturalComparator(false).compare("" + column.getValue(t1), "" + column.getValue(t2)));
    }

    public void addColumn(Column<T, ?> column, String header, Comparator<T> comparator) {
        ColumnSortEvent.ListHandler<T> boatColumnListHandler = this.getColumnSortHandler();
        column.setSortable(true);
        boatColumnListHandler.setComparator(column, comparator);
        this.addColumn(column, header);
    }

    public void addColumn(final Function<T, String> valueMapper, String header) {
        TextColumn textColumn = new TextColumn<T>(){

            public String getValue(T object) {
                return (String)valueMapper.apply(object);
            }
        };
        this.addColumn((Column<T, ?>)textColumn, header, (Comparator<T>)Comparator.comparing(arg_0 -> TableWrapper.lambda$1((TextColumn)textColumn, arg_0), new NaturalComparator()));
    }

    public void addColumn(final Function<T, String> valueMapper, String header, Comparator<T> comparator) {
        TextColumn textColumn = new TextColumn<T>(){

            public String getValue(T object) {
                return (String)valueMapper.apply(object);
            }
        };
        this.addColumn((Column<T, ?>)textColumn, header, comparator);
    }

    public void setEmptyTableWidget(Widget widget) {
        this.table.setEmptyTableWidget(widget);
    }

    public S getSelectionModel() {
        return this.selectionModel;
    }

    public ListDataProvider<T> getDataProvider() {
        return this.dataProvider;
    }

    public void add(T t) {
        this.getDataProvider().getList().add(t);
    }

    public void remove(T t) {
        this.getDataProvider().getList().remove(t);
    }

    public void replaceBasedOnEntityIdentityComparator(T t) {
        if (this.entityIdentityComparator == null) {
            this.remove(t);
            this.add(t);
        } else {
            for (Object existingElement : this.getDataProvider().getList()) {
                if (!this.entityIdentityComparator.representSameEntity(existingElement, t)) continue;
                this.remove(existingElement);
                this.add(t);
                break;
            }
        }
    }

    public void clear() {
        this.getDataProvider().getList().clear();
    }

    public void refresh(Iterable<T> newItems) {
        this.dataProvider.getList().clear();
        Util.addAll(newItems, (Collection)this.dataProvider.getList());
        this.dataProvider.refresh();
        this.dataProvider.flush();
    }

    public void registerSelectionModelOnNewDataProvider(ListDataProvider<T> dataProvider) {
        this.dataProvider = dataProvider;
        if (this.multiSelection) {
            if (this.selectionCheckboxColumn != null) {
                this.table.removeColumn(this.selectionCheckboxColumn);
            }
            this.selectionCheckboxColumn = new SelectionCheckboxColumn<T>(this.getTableRes().cellTableStyle().cellTableCheckboxSelected(), this.getTableRes().cellTableStyle().cellTableCheckboxDeselected(), this.getTableRes().cellTableStyle().cellTableCheckboxColumnCell(), this.entityIdentityComparator, dataProvider, this.table);
            this.columnSortHandler.setComparator(this.selectionCheckboxColumn, this.selectionCheckboxColumn.getComparator());
            RefreshableMultiSelectionModel<T> typedSelectionModel = this.selectionCheckboxColumn.getSelectionModel();
            this.selectionModel = typedSelectionModel;
            this.table.setSelectionModel((SelectionModel)this.selectionModel, (CellPreviewEvent.Handler)this.selectionCheckboxColumn.getSelectionManager());
            this.table.addColumn(this.selectionCheckboxColumn, this.selectionCheckboxColumn.getHeader());
        } else {
            RefreshableSingleSelectionModel<T> typedSelectionModel = new RefreshableSingleSelectionModel<T>(this.entityIdentityComparator, dataProvider);
            this.selectionModel = typedSelectionModel;
            this.table.setSelectionModel((SelectionModel)this.selectionModel);
        }
    }

    protected SM getStringMessages() {
        return this.stringMessages;
    }

    protected TR getTableRes() {
        return this.tableRes;
    }

    public static <X> X getSingleSelectedObjectOrNull(MultiSelectionModel<X> selectionModel) {
        return selectionModel.getSelectedSet() != null && selectionModel.getSelectedSet().size() == 1 ? (X)selectionModel.getSelectedSet().iterator().next() : null;
    }

    public void refresh() {
    }

    private static /* synthetic */ String lambda$1(TextColumn textColumn, Object t) {
        return (String)textColumn.getValue(t);
    }
}

