/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.celltable;

import com.google.gwt.user.cellview.client.Column;
import com.google.gwt.user.cellview.client.ColumnSortEvent;
import com.google.gwt.user.cellview.client.TextColumn;
import com.sap.sse.common.util.NaturalComparator;
import java.util.Comparator;
import java.util.function.Function;

public class AbstractSortableTextColumn<T>
extends TextColumn<T> {
    private final Function<T, String> stringSupplier;

    private static <T> Comparator<T> getNaturalComparator(Function<T, String> stringSupplier, boolean caseSensitive) {
        return (a, b) -> new NaturalComparator(caseSensitive).compare((String)stringSupplier.apply(a), (String)stringSupplier.apply(b));
    }

    public AbstractSortableTextColumn(Function<T, String> stringSupplier, ColumnSortEvent.ListHandler<T> listHandler) {
        this(stringSupplier, listHandler, false);
    }

    public AbstractSortableTextColumn(Function<T, String> stringSupplier, ColumnSortEvent.ListHandler<T> listHandler, boolean caseSensitive) {
        this(stringSupplier, listHandler, AbstractSortableTextColumn.getNaturalComparator(stringSupplier, caseSensitive));
    }

    public AbstractSortableTextColumn(Function<T, String> stringSupplier, ColumnSortEvent.ListHandler<T> listHandler, Comparator<T> comparator) {
        this.stringSupplier = stringSupplier;
        this.setSortable(true);
        listHandler.setComparator((Column)this, comparator);
    }

    public String getValue(T object) {
        return this.stringSupplier.apply(object);
    }
}

