/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.async;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.TimeRange;
import com.sap.sse.gwt.client.async.TimeRangeAsyncAction;
import com.sap.sse.gwt.client.async.TimeRangeAsyncCallback;
import com.sap.sse.gwt.client.async.TimeRangeResultCache;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TimeRangeActionsExecutor<Result, SubResult, Key> {
    private final Map<Key, TimeRangeResultCache<SubResult>> cacheMap = new HashMap<Key, TimeRangeResultCache<SubResult>>();

    public void execute(TimeRangeAsyncAction<Result, Key> action, TimeRangeAsyncCallback<Result, SubResult, Key> callback) {
        this.execute(action, callback, false);
    }

    public void execute(TimeRangeAsyncAction<Result, Key> action, TimeRangeAsyncCallback<Result, SubResult, Key> callback, boolean forceTimeRange) {
        if (action == null) {
            throw new IllegalArgumentException("action must not be null!");
        }
        if (callback == null) {
            throw new IllegalArgumentException("callback must not be null!");
        }
        Map<Key, TimeRange> requestedTimeRanges = action.getTimeRanges();
        final ExecutorCallback execCallback = new ExecutorCallback(action, requestedTimeRanges, callback);
        HashMap<Key, TimeRange> trimmedTimeRanges = new HashMap<Key, TimeRange>(requestedTimeRanges.size());
        for (final Map.Entry<Key, TimeRange> subRequest : requestedTimeRanges.entrySet()) {
            TimeRangeResultCache<SubResult> cache = this.getSubResultCache(subRequest.getKey());
            TimeRange potentiallyTrimmedTimeRange = cache.trimAndRegisterRequest(subRequest.getValue(), forceTimeRange, action, new AsyncCallback<Void>(){

                public void onFailure(Throwable caught) {
                    execCallback.onSubResultFailure(subRequest.getKey(), caught);
                }

                public void onSuccess(Void result) {
                    execCallback.onSubResultSuccess(subRequest.getKey());
                }
            });
            if (potentiallyTrimmedTimeRange == null) continue;
            trimmedTimeRanges.put(subRequest.getKey(), potentiallyTrimmedTimeRange);
        }
        action.execute(trimmedTimeRanges, execCallback);
    }

    private TimeRangeResultCache<SubResult> getSubResultCache(Key key) {
        return this.cacheMap.computeIfAbsent(key, k -> new TimeRangeResultCache());
    }

    private final class ExecutorCallback
    implements AsyncCallback<Result> {
        private final TimeRangeAsyncAction<Result, Key> action;
        private final TimeRangeAsyncCallback<Result, SubResult, Key> callback;
        private boolean callbackWasCalled = false;
        private final Map<Key, TimeRange> requestedTimeRangeMap;
        private final Set<Key> subResultsReadySet;

        private ExecutorCallback(TimeRangeAsyncAction<Result, Key> action, Map<Key, TimeRange> requestedTimeRanges, TimeRangeAsyncCallback<Result, SubResult, Key> callback) {
            this.action = action;
            this.callback = callback;
            this.requestedTimeRangeMap = new HashMap(requestedTimeRanges);
            this.subResultsReadySet = new HashSet(requestedTimeRanges.size());
        }

        public void onSuccess(Result result) {
            Map unzippedResultMap = result != null ? this.callback.unzipResult(result) : Collections.emptyMap();
            for (Object key : this.requestedTimeRangeMap.keySet()) {
                Object trimmedSubResultForKey = unzippedResultMap.get(key);
                TimeRangeResultCache cache = TimeRangeActionsExecutor.this.getSubResultCache(key);
                cache.registerResult(this.action, trimmedSubResultForKey);
            }
        }

        public void onFailure(Throwable caught) {
            this.requestedTimeRangeMap.keySet().forEach(key -> TimeRangeActionsExecutor.this.getSubResultCache(key).registerFailure(this.action, caught));
            if (!this.callbackWasCalled) {
                this.callback.onFailure(caught);
                this.callbackWasCalled = true;
            }
        }

        public void onSubResultSuccess(Key key) {
            if (!this.callbackWasCalled) {
                this.subResultsReadySet.add(key);
                if (this.subResultsReadySet.size() == this.requestedTimeRangeMap.size()) {
                    HashMap unzippedResult = new HashMap(this.subResultsReadySet.size());
                    for (Object k : this.subResultsReadySet) {
                        TimeRange requestedTimeRange = this.requestedTimeRangeMap.get(k);
                        List subResults = TimeRangeActionsExecutor.this.getSubResultCache(k).getResults(this.action);
                        unzippedResult.put(k, this.callback.joinSubResults(requestedTimeRange, subResults));
                    }
                    this.callback.onSuccess(this.callback.zipSubResults(unzippedResult));
                    this.callbackWasCalled = true;
                }
            }
        }

        public void onSubResultFailure(Key key, Throwable caught) {
            if (!this.callbackWasCalled) {
                for (Object k : this.requestedTimeRangeMap.keySet()) {
                    if (key.equals(k)) continue;
                    TimeRangeActionsExecutor.this.getSubResultCache(k).removeRequest(this.action);
                }
                this.callback.onFailure(caught);
                this.callbackWasCalled = true;
            }
        }
    }
}

