/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client.async;

import com.google.gwt.user.client.rpc.AsyncCallback;
import com.sap.sse.common.Duration;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.gwt.client.async.AsyncAction;
import com.sap.sse.gwt.client.async.MarkedAsyncCallback;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Logger;

public class AsyncActionsExecutor {
    private static final Logger logger = Logger.getLogger(AsyncActionsExecutor.class.getName());
    private static final int DEFAULT_MAX_PENDING_CALLS = 10;
    private static final int DEFAULT_MAX_PENDING_CALLS_PER_TYPE = 4;
    private static final Duration DURATION_AFTER_TO_RESET_QUEUE = Duration.ONE_MINUTE;
    private final int maxPendingCalls;
    private final int maxPendingCallsPerType;
    private final Duration durationAfterToResetQueue;
    private final Map<String, Integer> actionsPerTypeCounter;
    private final Map<String, ExecutionJob<?>> lastRequestedActionsNotBeingSentOut;
    private final Map<String, TimePoint> timePointOfTypeLastBeingExecuted;
    private final Map<String, Set<Runnable>> runAfterLastActionForCategoryReturned;
    private final Set<Runnable> runAfterLastActionReturned;
    private int numPendingCalls = 0;
    private TimePoint timePointOfFirstExecutorInit = null;

    public AsyncActionsExecutor() {
        this(10, 4, DURATION_AFTER_TO_RESET_QUEUE);
    }

    public AsyncActionsExecutor(int maxPendingCalls, int maxPendingCallsPerType, Duration durationAfterToResetQueue) {
        if (maxPendingCalls < maxPendingCallsPerType) {
            throw new RuntimeException("The number of max pending calls can not be lower than the number of max pending calls per type.");
        }
        this.runAfterLastActionForCategoryReturned = new HashMap<String, Set<Runnable>>();
        this.runAfterLastActionReturned = new HashSet<Runnable>();
        this.maxPendingCalls = maxPendingCalls;
        this.maxPendingCallsPerType = maxPendingCallsPerType;
        this.durationAfterToResetQueue = durationAfterToResetQueue;
        this.actionsPerTypeCounter = new HashMap<String, Integer>();
        this.lastRequestedActionsNotBeingSentOut = new HashMap();
        this.timePointOfTypeLastBeingExecuted = new HashMap<String, TimePoint>();
        this.timePointOfFirstExecutorInit = MillisecondsTimePoint.now();
    }

    public void runAfterLastActionReturned(String category, Runnable callback) {
        if (this.getNumberOfPendingActionsPerType(category) == 0) {
            callback.run();
        } else {
            Util.addToValueSet(this.runAfterLastActionForCategoryReturned, (Object)category, (Object)callback);
        }
    }

    public void runAfterLastActionReturned(Runnable callback) {
        if (this.getNumberOfPendingActions() == 0) {
            callback.run();
        } else {
            this.runAfterLastActionReturned.add(callback);
        }
    }

    public <T> void execute(AsyncAction<T> action, AsyncCallback<T> callback) {
        this.execute(action, "", callback);
    }

    public <T> void execute(AsyncAction<T> action, String category, AsyncCallback<T> callback) {
        this.execute(new ExecutionJob<T>(action, category, callback));
    }

    public int getNumberOfPendingActionsPerType(String type) {
        int result = 0;
        result = this.actionsPerTypeCounter.getOrDefault(type, 0);
        return result;
    }

    public int getNumberOfPendingActions() {
        return this.numPendingCalls;
    }

    private void execute(ExecutionJob<?> job) {
        Integer numActionsOfType = this.actionsPerTypeCounter.computeIfAbsent(job.getType(), j -> 0);
        if (this.numPendingCalls >= this.maxPendingCalls || numActionsOfType >= this.maxPendingCallsPerType) {
            TimePoint timePointToInspectForResetDecision;
            TimePoint now = MillisecondsTimePoint.now();
            TimePoint timePoint = timePointToInspectForResetDecision = this.timePointOfTypeLastBeingExecuted.get(job.getType()) != null ? this.timePointOfTypeLastBeingExecuted.get(job.getType()) : this.timePointOfFirstExecutorInit;
            if (timePointToInspectForResetDecision != null && now.minus(this.durationAfterToResetQueue).after(timePointToInspectForResetDecision)) {
                this.numPendingCalls = 0;
                for (String jobPendingTypeKey : this.lastRequestedActionsNotBeingSentOut.keySet()) {
                    this.actionsPerTypeCounter.put(jobPendingTypeKey, 0);
                }
                numActionsOfType = 0;
            } else {
                logger.info("Dropping action of type " + job.getType() + ", category " + job.getCategory());
                ExecutionJob<?> droppedJob = this.lastRequestedActionsNotBeingSentOut.put(job.getType(), job);
                if (droppedJob != null) {
                    droppedJob.dropped();
                }
                return;
            }
        }
        this.actionsPerTypeCounter.put(job.getType(), numActionsOfType + 1);
        ++this.numPendingCalls;
        job.execute();
    }

    private void callCompleted(ExecutionJob<?> job) {
        String type = job.getType();
        Integer numActionsPerType = this.actionsPerTypeCounter.get(type);
        if (numActionsPerType != null && numActionsPerType > 0) {
            Set<Runnable> callbacks;
            this.actionsPerTypeCounter.put(type, numActionsPerType - 1);
            if (numActionsPerType - 1 == 0 && (callbacks = this.runAfterLastActionForCategoryReturned.get(type)) != null) {
                callbacks.forEach(callback -> callback.run());
            }
        }
        --this.numPendingCalls;
        if (this.numPendingCalls == 0) {
            this.runAfterLastActionReturned.forEach(callback -> callback.run());
        }
        this.timePointOfTypeLastBeingExecuted.put(type, MillisecondsTimePoint.now());
        this.checkForEmptyCallQueue(type);
    }

    private void checkForEmptyCallQueue(String type) {
        Integer numActionsPerType = this.actionsPerTypeCounter.get(type);
        if (numActionsPerType != null && numActionsPerType < this.maxPendingCallsPerType && this.lastRequestedActionsNotBeingSentOut.containsKey(type)) {
            ExecutionJob<?> lastRequestedAction = this.lastRequestedActionsNotBeingSentOut.remove(type);
            logger.info("Executing last queued action of type: " + lastRequestedAction.getType());
            this.execute(lastRequestedAction);
        }
    }

    private class ExecutionJob<T>
    implements AsyncCallback<T> {
        private final AsyncAction<T> action;
        private final String category;
        private final AsyncCallback<T> callback;

        public ExecutionJob(AsyncAction<T> action, String category, AsyncCallback<T> callback) {
            this.action = action;
            this.category = category;
            this.callback = callback;
        }

        public String getCategory() {
            return this.category == null ? "" : this.category;
        }

        public String getType() {
            return this.action.getClass().getName();
        }

        public void execute() {
            this.action.execute(new MarkedAsyncCallback(this, this.getCategory()));
        }

        public void dropped() {
            this.action.dropped(AsyncActionsExecutor.this);
        }

        public void onSuccess(T result) {
            try {
                this.callback.onSuccess(result);
            }
            finally {
                AsyncActionsExecutor.this.callCompleted(this);
            }
        }

        public void onFailure(Throwable caught) {
            try {
                logger.warning("Execution failure for action of type " + this.getType() + ", category " + this.getCategory() + ": " + caught.getMessage());
                this.callback.onFailure(caught);
            }
            finally {
                AsyncActionsExecutor.this.callCompleted(this);
            }
        }
    }
}

