/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.core.client.GWT;
import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.event.shared.HandlerRegistration;
import com.sap.sse.gwt.client.StorageEvent;
import java.util.HashSet;
import java.util.Set;

public class Storage
extends JavaScriptObject {
    private static final Set<StorageEvent.Handler> storageEventHandlers = new HashSet<StorageEvent.Handler>();

    static {
        Storage.registerAsStorageEventHandler();
    }

    protected Storage() {
    }

    private static void registerAsStorageEventHandler() {
        if (Storage.isSupported()) {
            try {
                Storage.registerAsStorageEventHandlerImpl();
            }
            catch (Exception e) {
                GWT.log((String)e.getMessage());
            }
        }
    }

    private static native void registerAsStorageEventHandlerImpl();

    public static HandlerRegistration addStorageEventHandler(final StorageEvent.Handler handler) {
        storageEventHandlers.add(handler);
        return new HandlerRegistration(){

            public void removeHandler() {
                storageEventHandlers.remove(handler);
            }
        };
    }

    public static void removeStorageEventHandler(StorageEvent.Handler handler) {
        storageEventHandlers.remove(handler);
    }

    private static void onStorageEvent(JavaScriptObject event) {
        StorageEvent storageEvent = (StorageEvent)event.cast();
        for (StorageEvent.Handler handler : storageEventHandlers) {
            handler.onStorageChange(storageEvent);
        }
    }

    private static native JavaScriptObject getLocalStorageIfSupportedImpl();

    private static native JavaScriptObject getSessionStorageIfSupportedImpl();

    public static native boolean isLocalStorageSupported();

    public static native boolean isSessionStorageSupported();

    public static boolean isSupported() {
        return Storage.isLocalStorageSupported() && Storage.isSessionStorageSupported();
    }

    public static Storage getLocalStorageIfSupported() {
        Storage result = Storage.isLocalStorageSupported() ? (Storage)Storage.getLocalStorageIfSupportedImpl().cast() : null;
        return result;
    }

    public static Storage getSessionStorageIfSupported() {
        Storage result = Storage.isSessionStorageSupported() ? (Storage)Storage.getSessionStorageIfSupportedImpl().cast() : null;
        return result;
    }

    public final native void setItem(String var1, String var2);

    public final native String getItem(String var1);

    public final native void removeItem(String var1);

    public final native void clear();

    public final native String key(int var1);

    public final native int getLength();

    public final native String[] getAllKeys();
}

