/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.gwt.client;

import com.google.gwt.http.client.URL;
import com.google.gwt.place.shared.Place;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.StringJoiner;
import java.util.logging.Logger;

public abstract class AbstractBasePlace
extends Place {
    private static final Logger logger = Logger.getLogger(AbstractBasePlace.class.getName());
    private static final String VALIDATE_TOKENS_MESSAGE_PREFIX = "Missing token(s): ";
    private final String placeParametersAsToken;
    private final Map<String, String> params;

    protected AbstractBasePlace(Map<String, String> params) {
        this.params = new HashMap<String, String>();
        if (params != null) {
            this.params.putAll(params);
        }
        this.placeParametersAsToken = this.getTokenStringFromParameters(params);
    }

    protected AbstractBasePlace(String placeParamsFromUrlFragment) {
        this.params = this.extractUrlParams(placeParamsFromUrlFragment);
        this.placeParametersAsToken = this.getTokenStringFromParameters(this.params);
    }

    protected String getTokenStringFromParameters(Map<String, String> paramKeysAndValues) {
        StringJoiner stringJoiner = new StringJoiner("&");
        if (paramKeysAndValues != null) {
            for (Map.Entry<String, String> e : paramKeysAndValues.entrySet()) {
                String paramName = e.getKey();
                String paramValue = e.getValue();
                if (paramValue == null) continue;
                stringJoiner.add(String.valueOf(paramName) + "=" + paramValue);
            }
        }
        return stringJoiner.toString();
    }

    protected Map<String, String> extractUrlParams(String placeParamsFromUrlFragment) {
        HashMap<String, String> result = new HashMap<String, String>();
        if (placeParamsFromUrlFragment != null && !placeParamsFromUrlFragment.isEmpty()) {
            List<String> list = Arrays.asList(placeParamsFromUrlFragment.split("&"));
            if (list == null || list.size() < 1) {
                logger.warning("Token empty, no-op");
            } else {
                for (String listItem : list) {
                    List<String> nvPair = Arrays.asList(listItem.split("="));
                    if (nvPair == null || nvPair.size() != 2) {
                        logger.warning("Invalid parameters");
                        continue;
                    }
                    result.put(nvPair.get(0), nvPair.get(1));
                }
            }
        }
        return result;
    }

    protected void validate(String ... paramNames) {
        StringBuffer message = new StringBuffer(VALIDATE_TOKENS_MESSAGE_PREFIX);
        String[] stringArray = paramNames;
        int n = paramNames.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            if (!this.params.containsKey(name)) {
                message.append(String.valueOf(name) + " ");
            }
            ++n2;
        }
        if (!message.toString().equals(VALIDATE_TOKENS_MESSAGE_PREFIX)) {
            logger.warning(message.toString());
        }
    }

    public String getParametersAsToken() {
        return this.placeParametersAsToken;
    }

    public String getParameter(String name) {
        return this.params.get(name);
    }

    public String getParameterDecoded(String name) {
        String paramValue = this.params.get(name);
        return paramValue == null ? null : URL.decodeQueryString((String)paramValue);
    }

    public boolean hasParameter(String name) {
        return this.params.containsKey(name);
    }
}

