/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.persistence.impl;

import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiData;
import com.igtimi.IgtimiStream;
import com.mongodb.client.ClientSession;
import com.mongodb.client.FindIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Sorts;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.Device;
import com.sap.sailing.domain.igtimiadapter.persistence.DomainObjectFactory;
import com.sap.sailing.domain.igtimiadapter.persistence.impl.CollectionNames;
import com.sap.sailing.domain.igtimiadapter.persistence.impl.FieldNames;
import com.sap.sailing.domain.igtimiadapter.persistence.impl.MongoObjectFactoryImpl;
import com.sap.sse.common.MultiTimeRange;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.TimeRange;
import com.sap.sse.common.Util;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.Binary;

public class DomainObjectFactoryImpl
implements DomainObjectFactory {
    private static final Logger logger = Logger.getLogger(DomainObjectFactoryImpl.class.getName());
    private final MongoDatabase db;
    private final MongoCollection<Document> messagesCollection;

    public DomainObjectFactoryImpl(MongoDatabase db) {
        this.db = db;
        this.messagesCollection = MongoObjectFactoryImpl.getOrCreateMessagesCollection(db);
    }

    private TimePoint getTimePoint(Document o, FieldNames timePointFieldName) {
        Number startTimeMillisNumber = (Number)o.get((Object)timePointFieldName.name());
        TimePoint startTime = startTimeMillisNumber == null ? null : TimePoint.of((long)startTimeMillisNumber.longValue());
        return startTime;
    }

    @Override
    public Iterable<DataAccessWindow> getDataAccessWindows(ClientSession clientSessionOrNull) {
        ArrayList<DataAccessWindow> result = new ArrayList<DataAccessWindow>();
        MongoCollection dataAcccessWindowsCollection = this.db.getCollection(CollectionNames.IGTIMI_DATA_ACCESS_WINDOWS.name());
        FindIterable dawDocuments = clientSessionOrNull == null ? dataAcccessWindowsCollection.find() : dataAcccessWindowsCollection.find(clientSessionOrNull);
        for (Object o : dawDocuments) {
            Number id = (Number)((Document)o).get((Object)FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_ID.name());
            TimePoint startTime = this.getTimePoint((Document)o, FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_START_TIME_MILLIS);
            TimePoint endTime = this.getTimePoint((Document)o, FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_END_TIME_MILLIS);
            String deviceSerialNumber = (String)((Document)o).get((Object)FieldNames.IGTIMI_DATA_ACCESS_WINDOWS_DEVICE_SERIAL_NUMBER.name());
            result.add(DataAccessWindow.create((long)id.longValue(), (TimePoint)startTime, (TimePoint)endTime, (String)deviceSerialNumber));
        }
        return result;
    }

    @Override
    public Iterable<Device> getDevices(ClientSession clientSessionOrNull) {
        ArrayList<Device> result = new ArrayList<Device>();
        MongoCollection devicesCollection = this.db.getCollection(CollectionNames.IGTIMI_DEVICES.name());
        FindIterable deviceDocuments = clientSessionOrNull == null ? devicesCollection.find() : devicesCollection.find(clientSessionOrNull);
        for (Object o : deviceDocuments) {
            Number id = (Number)((Document)o).get((Object)FieldNames.IGTIMI_DEVICES_ID.name());
            String serialNumber = (String)((Document)o).get((Object)FieldNames.IGTIMI_DEVICES_SERIAL_NUMBER.name());
            String name = (String)((Document)o).get((Object)FieldNames.IGTIMI_DEVICES_NAME.name());
            Device device = Device.create((long)id.longValue(), (String)serialNumber, (String)name);
            Long lastHeartbeatMillis = ((Document)o).getLong((Object)FieldNames.IGTIMI_DEVICES_LAST_HEARTBEAT_MILLIS.name());
            if (lastHeartbeatMillis != null) {
                String remoteAddress = ((Document)o).getString((Object)FieldNames.IGTIMI_DEVICES_REMOTE_ADDRESS.name());
                device.setLastHeartbeat(lastHeartbeatMillis == null ? null : TimePoint.of((Long)lastHeartbeatMillis), remoteAddress);
            }
            result.add(device);
        }
        return result;
    }

    @Override
    public Iterable<IgtimiStream.Msg> getMessages(String deviceSerialNumber, MultiTimeRange timeRanges, Set<IgtimiData.DataPoint.DataCase> dataCases, ClientSession clientSessionOrNull) {
        Iterable<Object> result;
        if (timeRanges == null) {
            result = Collections.emptySet();
        } else {
            Document query = new Document();
            this.appendMultiTimeRangeQuery(query, timeRanges);
            query.append(FieldNames.IGTIMI_MESSAGES_DEVICE_SERIAL_NUMBER.name(), (Object)deviceSerialNumber);
            FindIterable queryResult = (clientSessionOrNull == null ? this.messagesCollection.find((Bson)query) : this.messagesCollection.find(clientSessionOrNull, (Bson)query)).sort(Sorts.ascending((String[])new String[]{FieldNames.IGTIMI_MESSAGES_TIMESTAMP.name()}));
            result = Util.filter((Iterable)Util.map((Iterable)queryResult, doc -> {
                try {
                    IgtimiStream.Msg msg = IgtimiStream.Msg.parseFrom((byte[])((Binary)doc.get((Object)FieldNames.IGTIMI_MESSAGES_PROTOBUF_MESSAGE.name(), Binary.class)).getData());
                    return this.filterMessageForDataCases(msg, dataCases);
                }
                catch (InvalidProtocolBufferException e) {
                    logger.log(Level.SEVERE, "Error trying to parse an Igtimi message for device " + deviceSerialNumber, e);
                    return null;
                }
            }), r -> r != null);
        }
        return result;
    }

    private IgtimiStream.Msg filterMessageForDataCases(IgtimiStream.Msg msg, Set<IgtimiData.DataPoint.DataCase> dataCases) {
        IgtimiStream.Msg.Builder messageBuilder = msg.toBuilder();
        List dataMsgBuilderList = messageBuilder.getDataBuilder().getDataBuilderList();
        for (IgtimiData.DataMsg.Builder b : dataMsgBuilderList) {
            List dataPointBuilderList = b.getDataBuilderList();
            ArrayList<IgtimiData.DataPoint.Builder> dataPointBuilders = new ArrayList<IgtimiData.DataPoint.Builder>();
            for (IgtimiData.DataPoint.Builder dataPointBuilder : dataPointBuilderList) {
                if (!dataCases.contains(dataPointBuilder.getDataCase())) continue;
                dataPointBuilders.add(dataPointBuilder);
            }
            b.clearData();
            dataPointBuilders.forEach(dpb -> {
                IgtimiData.DataMsg.Builder builder2 = b.addData(dpb);
            });
        }
        IgtimiStream.Msg result = messageBuilder.build();
        return this.hasDataPoints(result) ? result : null;
    }

    private boolean hasDataPoints(IgtimiStream.Msg result) {
        return result.getData().getDataList().stream().filter(dataMsg -> dataMsg.getDataCount() > 0).findAny().isPresent();
    }

    @Override
    public IgtimiStream.Msg getLatestMessage(String deviceSerialNumber, IgtimiData.DataPoint.DataCase dataCase, MultiTimeRange timeRanges, ClientSession clientSessionOrNull) throws InvalidProtocolBufferException {
        if (timeRanges != null) {
            Document query = new Document();
            query.append(FieldNames.IGTIMI_MESSAGES_DEVICE_SERIAL_NUMBER.name(), (Object)deviceSerialNumber);
            this.appendMultiTimeRangeQuery(query, timeRanges);
            FindIterable documentsUnsorted = clientSessionOrNull == null ? this.messagesCollection.find((Bson)query) : this.messagesCollection.find(clientSessionOrNull, (Bson)query);
            FindIterable queryResult = documentsUnsorted.sort(Sorts.descending((String[])new String[]{FieldNames.IGTIMI_MESSAGES_TIMESTAMP.name()}));
            for (Document document : queryResult) {
                Binary messageBinary = (Binary)document.get((Object)FieldNames.IGTIMI_MESSAGES_PROTOBUF_MESSAGE.name());
                IgtimiStream.Msg msg = IgtimiStream.Msg.parseFrom((byte[])messageBinary.getData());
                if (!msg.hasData()) continue;
                IgtimiData.Data data = msg.getData();
                ListIterator i = data.getDataList().listIterator(data.getDataCount());
                while (i.hasPrevious()) {
                    IgtimiData.DataMsg dataMsg = (IgtimiData.DataMsg)i.previous();
                    ListIterator j = dataMsg.getDataList().listIterator(dataMsg.getDataCount());
                    while (j.hasPrevious()) {
                        IgtimiData.DataPoint dataPoint = (IgtimiData.DataPoint)j.previous();
                        if (dataPoint.getDataCase() != dataCase) continue;
                        return IgtimiStream.Msg.newBuilder().setData(IgtimiData.Data.newBuilder().addData(IgtimiData.DataMsg.newBuilder().addData(dataPoint).setSerialNumber(deviceSerialNumber).build()).build()).build();
                    }
                }
            }
        }
        return null;
    }

    private void appendMultiTimeRangeQuery(Document query, MultiTimeRange timeRanges) {
        ArrayList<Document> or = new ArrayList<Document>();
        for (TimeRange timeRange : timeRanges) {
            Document timeRangeQuery = new Document();
            if (timeRange.from() != null) {
                timeRangeQuery.append("$gte", (Object)timeRange.from().asDate());
            }
            if (timeRange.to() != null) {
                timeRangeQuery.append("$lt", (Object)timeRange.to().asDate());
            }
            if (timeRangeQuery.isEmpty()) continue;
            Document clauseForOr = new Document();
            clauseForOr.append(FieldNames.IGTIMI_MESSAGES_TIMESTAMP.name(), (Object)timeRangeQuery);
            or.add(clauseForOr);
        }
        query.append("$or", or);
    }
}

