/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.resultimport.impl;

import com.sap.sailing.resultimport.ResultDocumentDescriptor;
import com.sap.sailing.resultimport.ResultDocumentProvider;
import com.sap.sailing.resultimport.impl.ResultDocumentDescriptorImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.logging.Logger;

public class FileBasedResultDocumentProvider
implements ResultDocumentProvider {
    private static final Logger logger = Logger.getLogger(FileBasedResultDocumentProvider.class.getName());
    private final File scanDir;

    public FileBasedResultDocumentProvider(File scanDir) {
        this.scanDir = scanDir;
    }

    @Override
    public Iterable<ResultDocumentDescriptor> getResultDocumentDescriptors() throws IOException {
        ArrayList<ResultDocumentDescriptor> result = new ArrayList<ResultDocumentDescriptor>();
        File[] fileList = this.scanDir.listFiles();
        if (fileList != null) {
            File[] fileArray = fileList;
            int n = fileList.length;
            int n2 = 0;
            while (n2 < n) {
                File file = fileArray[n2];
                if (file.canRead() && file.isFile() && !file.getName().startsWith(".")) {
                    logger.fine("adding " + file + " to result import list");
                    result.add(new ResultDocumentDescriptorImpl(new FileInputStream(file), file.toString(), (TimePoint)new MillisecondsTimePoint(file.lastModified())));
                }
                ++n2;
            }
        }
        return result;
    }
}

