/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sailing.domain.igtimiadapter.DataAccessWindow;
import com.sap.sailing.domain.igtimiadapter.impl.HasIdImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;

public class DataAccessWindowImpl
extends HasIdImpl
implements DataAccessWindow {
    private static final long serialVersionUID = -7076166985273850220L;
    private final TimePoint startTime;
    private final TimePoint endTime;
    private final String deviceSerialNumber;

    public DataAccessWindowImpl(long id, TimePoint startTime, TimePoint endTime, String deviceSerialNumber) {
        super(id);
        this.startTime = startTime;
        this.endTime = endTime;
        this.deviceSerialNumber = deviceSerialNumber;
    }

    @Override
    public TimePoint getStartTime() {
        return this.startTime;
    }

    @Override
    public TimePoint getEndTime() {
        return this.endTime;
    }

    @Override
    public String getDeviceSerialNumber() {
        return this.deviceSerialNumber;
    }

    public String toString() {
        return "DAW " + this.getId() + " for device " + this.getDeviceSerialNumber() + " from " + this.getStartTime() + " to " + this.getEndTime();
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(DataAccessWindow.createTypeRelativeObjectIdentifier(this.getDeviceSerialNumber(), this.getStartTime(), this.getEndTime()));
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.IGTIMI_DATA_ACCESS_WINDOW;
    }

    public String getName() {
        return "Data Access Window for device " + this.getDeviceSerialNumber() + " from " + this.getStartTime().asMillis() + " to " + this.getEndTime().asMillis();
    }
}

