/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.impl;

import com.sap.sailing.domain.igtimiadapter.IgtimiConnectionFactory;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiConnectionFactoryImpl;
import com.sap.sailing.domain.igtimiadapter.impl.IgtimiWindTrackerFactory;
import com.sap.sailing.domain.tracking.WindTrackerFactory;
import com.sap.sse.replication.FullyInitializedReplicableTracker;
import com.sap.sse.security.SecurityService;
import com.sap.sse.util.impl.ThreadFactoryWithPriority;
import java.io.IOException;
import java.net.URL;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.http.client.ClientProtocolException;
import org.json.simple.parser.ParseException;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;

public class Activator
implements BundleActivator {
    private static final Logger logger = Logger.getLogger(Activator.class.getName());
    private static final String IGTIMI_BASE_URL_PROPERTY_NAME = "igtimi.base.url";
    private static final String IGTIMI_DEFAULT_BEARER_TOKEN_PROPERTY_NAME = "igtimi.bearer.token";
    private static Activator INSTANCE;
    private final IgtimiConnectionFactory connectionFactory;
    private final Future<IgtimiWindTrackerFactory> windTrackerFactory;
    private FullyInitializedReplicableTracker<SecurityService> securityServiceServiceTracker;
    private final ExecutorService executor = Executors.newSingleThreadExecutor((ThreadFactory)new ThreadFactoryWithPriority(5, Boolean.valueOf(true)));
    private SecurityService securityServiceTest;

    public Activator() throws ClientProtocolException, IllegalStateException, IOException, ParseException {
        logger.info(String.valueOf(this.getClass().getName()) + " constructor");
        URL baseUrl = new URL(System.getProperty(IGTIMI_BASE_URL_PROPERTY_NAME, "https://wind.sapsailing.com/"));
        logger.info("Using base URL " + baseUrl + " for the Igtimi REST API");
        logger.info("Creating IgtimiConnectionFactory");
        String defaultBearerToken = System.getProperty(IGTIMI_DEFAULT_BEARER_TOKEN_PROPERTY_NAME);
        if (defaultBearerToken != null) {
            logger.info("A default bearer token has been provided for authentication to the Igtimi REST API at " + baseUrl);
        }
        this.connectionFactory = new IgtimiConnectionFactoryImpl(baseUrl, defaultBearerToken);
        this.windTrackerFactory = this.executor.submit(new Callable<IgtimiWindTrackerFactory>(){

            @Override
            public IgtimiWindTrackerFactory call() throws InterruptedException, ExecutionException {
                logger.info("Creating IgtimiWindTrackerFactory");
                return new IgtimiWindTrackerFactory(Activator.this.connectionFactory);
            }
        });
    }

    public void setSecurityService(SecurityService securityService) {
        this.securityServiceTest = securityService;
    }

    public void start(final BundleContext context) throws Exception {
        INSTANCE = this;
        this.executor.submit(new Runnable(){

            @Override
            public void run() {
                try {
                    context.registerService(IgtimiConnectionFactory.class, (Object)Activator.this.connectionFactory, null);
                    context.registerService(WindTrackerFactory.class, (Object)((WindTrackerFactory)Activator.this.windTrackerFactory.get()), null);
                    context.registerService(IgtimiWindTrackerFactory.class, (Object)((IgtimiWindTrackerFactory)Activator.this.windTrackerFactory.get()), null);
                }
                catch (InterruptedException | ExecutionException e) {
                    logger.log(Level.SEVERE, "Error trying to register Igtimi services with OSGi", e);
                    throw new RuntimeException(e);
                }
            }
        });
        this.securityServiceServiceTracker = FullyInitializedReplicableTracker.createAndOpen((BundleContext)context, SecurityService.class);
    }

    public static Activator getInstance() throws ClientProtocolException, IllegalStateException, IOException, ParseException {
        if (INSTANCE == null) {
            INSTANCE = new Activator();
        }
        return INSTANCE;
    }

    public SecurityService getSecurityService() {
        try {
            return this.securityServiceTest == null ? (SecurityService)this.securityServiceServiceTracker.getInitializedService(0L) : this.securityServiceTest;
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }

    public IgtimiWindTrackerFactory getWindTrackerFactory() {
        try {
            return this.windTrackerFactory.get();
        }
        catch (InterruptedException | ExecutionException e) {
            logger.log(Level.SEVERE, "Error trying to retrieve Igtimi wind tracker factory", e);
            throw new RuntimeException(e);
        }
    }

    public void stop(BundleContext context) throws Exception {
        this.securityServiceServiceTracker.close();
        this.securityServiceServiceTracker = null;
    }
}

