/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter.datatypes;

import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.igtimiadapter.IgtimiFixReceiver;
import com.sap.sailing.domain.igtimiadapter.Sensor;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sse.common.TimePoint;
import java.util.Map;

public class GpsLatLong
extends Fix {
    private static final long serialVersionUID = 5056284867725893553L;
    private final Position position;

    public GpsLatLong(TimePoint timePoint, Sensor sensor, Map<Integer, Object> valuesPerSubindex) {
        this(timePoint, sensor, GpsLatLong.getPosition(valuesPerSubindex));
    }

    public GpsLatLong(TimePoint timePoint, Sensor sensor, Position position) {
        super(sensor, timePoint);
        this.position = position;
    }

    private static Position getPosition(Map<Integer, Object> valuesPerSubindex) {
        double longitudeInDegrees = ((Number)valuesPerSubindex.get(1)).doubleValue();
        double latitudeInDegrees = ((Number)valuesPerSubindex.get(2)).doubleValue();
        return new DegreePosition(latitudeInDegrees, longitudeInDegrees);
    }

    public Position getPosition() {
        return this.position;
    }

    @Override
    protected String localToString() {
        return this.position.toString();
    }

    @Override
    public void notify(IgtimiFixReceiver receiver) {
        receiver.received(this);
    }
}

