/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.igtimiadapter;

import com.google.protobuf.InvalidProtocolBufferException;
import com.igtimi.IgtimiData;
import com.igtimi.IgtimiStream;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KilometersPerHourSpeedImpl;
import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.igtimiadapter.DataPointVisitor;
import com.sap.sailing.domain.igtimiadapter.MsgVisitor;
import com.sap.sailing.domain.igtimiadapter.Sensor;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWA;
import com.sap.sailing.domain.igtimiadapter.datatypes.AWS;
import com.sap.sailing.domain.igtimiadapter.datatypes.BatteryLevel;
import com.sap.sailing.domain.igtimiadapter.datatypes.COG;
import com.sap.sailing.domain.igtimiadapter.datatypes.Fix;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsAltitude;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsLatLong;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsQualityHdop;
import com.sap.sailing.domain.igtimiadapter.datatypes.GpsQualitySatCount;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDG;
import com.sap.sailing.domain.igtimiadapter.datatypes.HDGM;
import com.sap.sailing.domain.igtimiadapter.datatypes.Log;
import com.sap.sailing.domain.igtimiadapter.datatypes.SOG;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.DegreeBearingImpl;
import com.sun.jersey.core.util.Base64;
import java.util.ArrayList;
import java.util.Map;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class FixFactory {
    public Iterable<Fix> createFixes(JSONObject sensorsJson) throws InvalidProtocolBufferException {
        ArrayList<Fix> result = new ArrayList<Fix>();
        for (Map.Entry e : sensorsJson.entrySet()) {
            String deviceSerialNumber = (String)e.getKey();
            JSONArray messagesAsBase64 = (JSONArray)e.getValue();
            Util.addAll(this.createFixesForTypes(deviceSerialNumber, messagesAsBase64), result);
        }
        return result;
    }

    private Iterable<Fix> createFixesForTypes(String deviceSerialNumber, JSONArray messagesAsBase64) throws InvalidProtocolBufferException {
        ArrayList<Fix> result = new ArrayList<Fix>();
        for (Object messageAsBase64 : messagesAsBase64) {
            IgtimiStream.Msg msg = IgtimiStream.Msg.parseFrom(Base64.decode((String)messageAsBase64.toString()));
            Util.addAll(this.createFixes(msg), result);
        }
        return result;
    }

    public Iterable<Fix> createFixes(IgtimiStream.Msg message) {
        final ArrayList<Fix> fixes = new ArrayList<Fix>();
        MsgVisitor.accept(message, new MsgVisitor(){

            @Override
            public void handleData(IgtimiData.Data data) {
                for (IgtimiData.DataMsg dataMsg : data.getDataList()) {
                    final String serialNumber = dataMsg.getSerialNumber();
                    for (IgtimiData.DataPoint dataPoint : dataMsg.getDataList()) {
                        DataPointVisitor.accept(dataPoint, new DataPointVisitor<Void>(){

                            @Override
                            public Void handleAwa(IgtimiData.ApparentWindAngle awa) {
                                fixes.add(new AWA(TimePoint.of((long)awa.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Bearing)new DegreeBearingImpl(awa.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleAws(IgtimiData.ApparentWindSpeed aws) {
                                fixes.add(new AWS(TimePoint.of((long)aws.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Speed)new KilometersPerHourSpeedImpl(aws.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleCog(IgtimiData.CourseOverGround cog) {
                                fixes.add(new COG(TimePoint.of((long)cog.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Bearing)new DegreeBearingImpl(cog.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleHdg(IgtimiData.Heading hdg) {
                                fixes.add(new HDG(TimePoint.of((long)hdg.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Bearing)new DegreeBearingImpl(hdg.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleHdgm(IgtimiData.HeadingMagnetic hdgm) {
                                fixes.add(new HDGM(TimePoint.of((long)hdgm.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Bearing)new DegreeBearingImpl(hdgm.getValue())));
                                return null;
                            }

                            @Override
                            public Void handlePos(IgtimiData.GNSS_Position pos) {
                                Sensor sensor = FixFactory.this.getSensor(serialNumber);
                                fixes.add(new GpsLatLong(TimePoint.of((long)pos.getTimestamp()), sensor, (Position)new DegreePosition(pos.getLatitude(), pos.getLongitude())));
                                fixes.add(new GpsAltitude(TimePoint.of((long)pos.getTimestamp()), sensor, (Distance)new MeterDistance(pos.getAltitude())));
                                return null;
                            }

                            @Override
                            public Void handleSatq(IgtimiData.GNSS_Quality hdop) {
                                fixes.add(new GpsQualityHdop(TimePoint.of((long)hdop.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Distance)new MeterDistance((double)hdop.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleSatc(IgtimiData.GNSS_Sat_Count satCount) {
                                fixes.add(new GpsQualitySatCount(TimePoint.of((long)satCount.getTimestamp()), FixFactory.this.getSensor(serialNumber), satCount.getValue()));
                                return null;
                            }

                            @Override
                            public Void handleNum(IgtimiData.Number num) {
                                fixes.add(new BatteryLevel(TimePoint.of((long)num.getTimestamp()), FixFactory.this.getSensor(serialNumber), num.getValue()));
                                return null;
                            }

                            @Override
                            public Void handleSog(IgtimiData.SpeedOverGround sog) {
                                fixes.add(new SOG(TimePoint.of((long)sog.getTimestamp()), FixFactory.this.getSensor(serialNumber), (Speed)new KilometersPerHourSpeedImpl(sog.getValue())));
                                return null;
                            }

                            @Override
                            public Void handleLog(IgtimiData.Log log) {
                                fixes.add(new Log(TimePoint.of((long)log.getTimestamp()), FixFactory.this.getSensor(serialNumber), log.getMessage(), log.getPriority()));
                                return null;
                            }
                        });
                    }
                }
            }
        });
        return fixes;
    }

    private Sensor getSensor(String serialNumber) {
        return Sensor.create(serialNumber, 0L);
    }
}

