/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.bravoadapter.impl;

import com.sap.sailing.declination.DeclinationService;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.sensordata.BravoExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.GPSFixMovingImpl;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifier;
import com.sap.sailing.domain.trackfiles.TrackFileImportDeviceIdentifierImpl;
import com.sap.sailing.domain.trackimport.FormatNotSupportedException;
import com.sap.sailing.domain.trackimport.GPSFixImporter;
import com.sap.sailing.server.gateway.windimport.bravo.FunnyDegreeConverter;
import com.sap.sailing.server.trackfiles.impl.BravoExtendedDataImporterImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Date;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BravoGPSFixImporter
implements GPSFixImporter {
    private static final Logger logger = Logger.getLogger(BravoGPSFixImporter.class.getName());

    public boolean importFixes(InputStream inputStream, Charset charset, GPSFixImporter.Callback callback, boolean inferSpeedAndBearing, String filename) throws FormatNotSupportedException, IOException {
        AtomicBoolean importedFixes = new AtomicBoolean(false);
        TrackFileImportDeviceIdentifierImpl device = new TrackFileImportDeviceIdentifierImpl(filename, String.valueOf(this.getType()) + "@" + new Date());
        new BravoExtendedDataImporterImpl().importFixes(inputStream, charset, (arg_0, arg_1) -> BravoGPSFixImporter.lambda$0(callback, (TrackFileImportDeviceIdentifier)device, importedFixes, arg_0, arg_1), filename, this.getType(), false);
        return importedFixes.get();
    }

    public Iterable<String> getSupportedFileExtensions() {
        return Arrays.asList("csv", "log", "txt");
    }

    public String getType() {
        return "Bravo";
    }

    private static /* synthetic */ void lambda$0(GPSFixImporter.Callback callback, TrackFileImportDeviceIdentifier trackFileImportDeviceIdentifier, AtomicBoolean atomicBoolean, Iterable fixes, TrackFileImportDeviceIdentifier deviceIdentifier) {
        for (DoubleVectorFix fix : fixes) {
            Bearing optionalTrueHeading;
            DegreePosition position = new DegreePosition(FunnyDegreeConverter.funnyLatLng((double)fix.get(BravoExtendedSensorDataMetadata.LAT.getColumnIndex())), FunnyDegreeConverter.funnyLatLng((double)fix.get(BravoExtendedSensorDataMetadata.LON.getColumnIndex())));
            if (fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_HDG.getColumnIndex()) != null) {
                try {
                    optionalTrueHeading = new DegreeBearingImpl(fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_HDG.getColumnIndex()).doubleValue()).add(DeclinationService.INSTANCE.getDeclination(fix.getTimePoint(), (Position)position, 100L).getBearingCorrectedTo(fix.getTimePoint()));
                }
                catch (IOException | ParseException e) {
                    logger.log(Level.WARNING, "Problem looking up magnetic declination for Bravo fix", e);
                    optionalTrueHeading = null;
                }
            } else {
                optionalTrueHeading = null;
            }
            GPSFixMovingImpl gpsFix = new GPSFixMovingImpl((Position)position, fix.getTimePoint(), (SpeedWithBearing)new KnotSpeedWithBearingImpl(fix.get(BravoExtendedSensorDataMetadata.SOG.getColumnIndex()).doubleValue(), (Bearing)new DegreeBearingImpl(fix.get(BravoExtendedSensorDataMetadata.COG.getColumnIndex()).doubleValue())), optionalTrueHeading);
            callback.addFix((GPSFix)gpsFix, trackFileImportDeviceIdentifier);
            atomicBoolean.set(true);
        }
    }
}

