/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFixMoving;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactGPSFixMovingImpl;
import com.sap.sailing.domain.common.tracking.impl.CompactPositionHelper;
import com.sap.sailing.domain.common.tracking.impl.CompactionNotPossibleException;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;
import java.util.logging.Level;
import java.util.logging.Logger;

public class VeryCompactGPSFixMovingImpl
extends AbstractCompactGPSFixMovingImpl {
    private static final long serialVersionUID = 3977983319207618335L;
    private static final Logger logger = Logger.getLogger(VeryCompactGPSFixMovingImpl.class.getName());
    private final int latDegScaled;
    private final int lngDegScaled;
    private final short speedInKnotsScaled;
    private final short degreeBearingScaled;
    private final short trueHeadingDegreesScaled;
    private final boolean trueHeadingDegreesSet;
    private short cachedEstimatedSpeedBearingInDegreesScaled;
    private short cachedEstimatedSpeedInKnotsScaled;

    public VeryCompactGPSFixMovingImpl(Position position, TimePoint timePoint, SpeedWithBearing speed, Bearing optionalTrueHeading) throws CompactionNotPossibleException {
        super(timePoint);
        this.latDegScaled = CompactPositionHelper.getLatDegScaled(position);
        this.lngDegScaled = CompactPositionHelper.getLngDegScaled(position);
        if (speed == null) {
            this.speedInKnotsScaled = 0;
            this.degreeBearingScaled = 0;
        } else {
            this.speedInKnotsScaled = CompactPositionHelper.getKnotSpeedScaled(speed);
            this.degreeBearingScaled = CompactPositionHelper.getDegreeBearingScaled(speed.getBearing());
        }
        if (optionalTrueHeading == null) {
            this.trueHeadingDegreesSet = false;
            this.trueHeadingDegreesScaled = 0;
        } else {
            this.trueHeadingDegreesSet = true;
            this.trueHeadingDegreesScaled = CompactPositionHelper.getDegreeBearingScaled(optionalTrueHeading);
        }
    }

    public VeryCompactGPSFixMovingImpl(GPSFixMoving gpsFixMoving) throws CompactionNotPossibleException {
        this(gpsFixMoving.getPosition(), gpsFixMoving.getTimePoint(), gpsFixMoving.getSpeed(), gpsFixMoving.getOptionalTrueHeading());
    }

    @Override
    public SpeedWithBearing getSpeed() {
        return new VeryCompactSpeedWithBearing();
    }

    @Override
    public Bearing getOptionalTrueHeading() {
        return this.trueHeadingDegreesSet ? new VeryCompactTrueHeading() : null;
    }

    @Override
    public Position getPosition() {
        return new VeryCompactPosition();
    }

    @Override
    public SpeedWithBearing getCachedEstimatedSpeed() {
        assert (this.isEstimatedSpeedCached());
        return new VeryCompactEstimatedSpeed();
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        try {
            this.cachedEstimatedSpeedInKnotsScaled = CompactPositionHelper.getKnotSpeedScaled(estimatedSpeed);
            this.cachedEstimatedSpeedBearingInDegreesScaled = CompactPositionHelper.getDegreeBearingScaled(estimatedSpeed.getBearing());
            super.cacheEstimatedSpeed(estimatedSpeed);
        }
        catch (CompactionNotPossibleException e) {
            logger.log(Level.FINER, "Cannot cache estimated speed " + estimatedSpeed + " in compact fix:", e);
        }
    }

    private class VeryCompactBearing
    extends AbstractBearing {
        private static final long serialVersionUID = 8167886382067060570L;

        private VeryCompactBearing() {
        }

        public double getDegrees() {
            return CompactPositionHelper.getDegreeBearing(VeryCompactGPSFixMovingImpl.this.degreeBearingScaled);
        }
    }

    public class VeryCompactEstimatedSpeed
    extends AbstractSpeedWithAbstractBearingImpl {
        private static final long serialVersionUID = -5871855443391817248L;

        @Override
        public Bearing getBearing() {
            return new VeryCompactEstimatedSpeedBearing();
        }

        @Override
        public double getKnots() {
            return CompactPositionHelper.getKnotSpeed(VeryCompactGPSFixMovingImpl.this.cachedEstimatedSpeedInKnotsScaled);
        }
    }

    private class VeryCompactEstimatedSpeedBearing
    extends AbstractBearing {
        private static final long serialVersionUID = 8549231429037883121L;

        private VeryCompactEstimatedSpeedBearing() {
        }

        public double getDegrees() {
            return CompactPositionHelper.getDegreeBearing(VeryCompactGPSFixMovingImpl.this.cachedEstimatedSpeedBearingInDegreesScaled);
        }
    }

    public class VeryCompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return CompactPositionHelper.getLatDeg(VeryCompactGPSFixMovingImpl.this.latDegScaled);
        }

        @Override
        public double getLngDeg() {
            return CompactPositionHelper.getLngDeg(VeryCompactGPSFixMovingImpl.this.lngDegScaled);
        }
    }

    public class VeryCompactSpeedWithBearing
    extends AbstractCompactGPSFixMovingImpl.AbstractCompactSpeedWithBearing {
        private static final long serialVersionUID = 1802065090733146728L;

        @Override
        public double getKnots() {
            return CompactPositionHelper.getKnotSpeed(VeryCompactGPSFixMovingImpl.this.speedInKnotsScaled);
        }

        @Override
        public Bearing getBearing() {
            return new VeryCompactBearing();
        }
    }

    private class VeryCompactTrueHeading
    extends AbstractBearing {
        private static final long serialVersionUID = 1130980861113826462L;

        private VeryCompactTrueHeading() {
        }

        public double getDegrees() {
            return CompactPositionHelper.getDegreeBearing(VeryCompactGPSFixMovingImpl.this.trueHeadingDegreesScaled);
        }
    }
}

