/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.AbstractPosition;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.AbstractSpeedWithAbstractBearingImpl;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.AbstractCompactGPSFixImpl;
import com.sap.sse.common.AbstractBearing;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.TimePoint;

public class PreciseCompactGPSFixImpl
extends AbstractCompactGPSFixImpl {
    private static final long serialVersionUID = 8167588584536992501L;
    private final double latDeg;
    private final double lngDeg;
    private double cachedEstimatedSpeedBearingInDegrees;
    private double cachedEstimatedSpeedInKnots;

    public PreciseCompactGPSFixImpl(Position position, TimePoint timePoint) {
        super(timePoint);
        this.latDeg = position.getLatDeg();
        this.lngDeg = position.getLngDeg();
    }

    public PreciseCompactGPSFixImpl(GPSFix gpsFix) {
        this(gpsFix.getPosition(), gpsFix.getTimePoint());
    }

    @Override
    public Position getPosition() {
        return new PreciseCompactPosition();
    }

    @Override
    public SpeedWithBearing getCachedEstimatedSpeed() {
        assert (this.isEstimatedSpeedCached());
        return new PreciseCompactEstimatedSpeed();
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        this.cachedEstimatedSpeedBearingInDegrees = estimatedSpeed.getBearing().getDegrees();
        this.cachedEstimatedSpeedInKnots = estimatedSpeed.getKnots();
        super.cacheEstimatedSpeed(estimatedSpeed);
    }

    private class PreciseCompactEstimatedSpeed
    extends AbstractSpeedWithAbstractBearingImpl {
        private static final long serialVersionUID = -5871855443391817248L;

        private PreciseCompactEstimatedSpeed() {
        }

        @Override
        public Bearing getBearing() {
            return new PreciseCompactEstimatedSpeedBearing();
        }

        @Override
        public double getKnots() {
            return PreciseCompactGPSFixImpl.this.cachedEstimatedSpeedInKnots;
        }
    }

    private class PreciseCompactEstimatedSpeedBearing
    extends AbstractBearing {
        private static final long serialVersionUID = 8549231429037883121L;

        private PreciseCompactEstimatedSpeedBearing() {
        }

        public double getDegrees() {
            return PreciseCompactGPSFixImpl.this.cachedEstimatedSpeedBearingInDegrees;
        }
    }

    public class PreciseCompactPosition
    extends AbstractPosition {
        private static final long serialVersionUID = 5621506820766614178L;

        @Override
        public double getLatDeg() {
            return PreciseCompactGPSFixImpl.this.latDeg;
        }

        @Override
        public double getLngDeg() {
            return PreciseCompactGPSFixImpl.this.lngDeg;
        }
    }
}

