/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.impl.MeterDistance;
import com.sap.sailing.domain.common.sensordata.BravoExtendedSensorDataMetadata;
import com.sap.sailing.domain.common.sensordata.ColumnMetadata;
import com.sap.sailing.domain.common.tracking.BravoExtendedFix;
import com.sap.sailing.domain.common.tracking.DoubleVectorFix;
import com.sap.sailing.domain.common.tracking.impl.BravoFixImpl;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.Distance;
import com.sap.sse.common.impl.DegreeBearingImpl;

public class BravoExtendedFixImpl
extends BravoFixImpl
implements BravoExtendedFix {
    private static final long serialVersionUID = 5622321493028301922L;

    public BravoExtendedFixImpl(DoubleVectorFix fix) {
        super(fix);
    }

    @Override
    protected ColumnMetadata resolveMetadataFromValueName(String valueName) {
        return BravoExtendedSensorDataMetadata.byColumnName(valueName);
    }

    @Override
    public Double getPortDaggerboardRake() {
        return this.fix.get(BravoExtendedSensorDataMetadata.DB_RAKE_PORT.getColumnIndex());
    }

    @Override
    public Double getStbdDaggerboardRake() {
        return this.fix.get(BravoExtendedSensorDataMetadata.DB_RAKE_STBD.getColumnIndex());
    }

    @Override
    public Double getPortRudderRake() {
        return this.fix.get(BravoExtendedSensorDataMetadata.RUDDER_RAKE_PORT.getColumnIndex());
    }

    @Override
    public Double getStbdRudderRake() {
        return this.fix.get(BravoExtendedSensorDataMetadata.RUDDER_RAKE_STBD.getColumnIndex());
    }

    @Override
    public Bearing getMastRotation() {
        Double bearingDeg = this.fix.get(BravoExtendedSensorDataMetadata.MAST_ROTATION.getColumnIndex());
        return bearingDeg == null ? null : new DegreeBearingImpl(bearingDeg.doubleValue());
    }

    @Override
    public Bearing getLeeway() {
        Double leeway = this.fix.get(BravoExtendedSensorDataMetadata.LEEWAY.getColumnIndex());
        return leeway == null ? null : new DegreeBearingImpl(leeway.doubleValue());
    }

    @Override
    public Double getSet() {
        return this.fix.get(BravoExtendedSensorDataMetadata.SET.getColumnIndex());
    }

    @Override
    public Bearing getDrift() {
        Double drift = this.fix.get(BravoExtendedSensorDataMetadata.DRIFT.getColumnIndex());
        return drift == null ? null : new DegreeBearingImpl(drift.doubleValue());
    }

    @Override
    public Distance getDepth() {
        Double depthInMeters = this.fix.get(BravoExtendedSensorDataMetadata.DEPTH.getColumnIndex());
        return depthInMeters == null ? null : new MeterDistance(depthInMeters);
    }

    @Override
    public Bearing getRudder() {
        Double rudderAngleDeg = this.fix.get(BravoExtendedSensorDataMetadata.RUDDER.getColumnIndex());
        return rudderAngleDeg == null ? null : new DegreeBearingImpl(rudderAngleDeg.doubleValue());
    }

    @Override
    public Double getForestayLoad() {
        return this.fix.get(BravoExtendedSensorDataMetadata.FORESTAY_LOAD.getColumnIndex());
    }

    @Override
    public Double getForestayPressure() {
        return this.fix.get(BravoExtendedSensorDataMetadata.FORESTAY_PRESSURE.getColumnIndex());
    }

    @Override
    public Bearing getTackAngle() {
        Double tackAngleDeg = this.fix.get(BravoExtendedSensorDataMetadata.TACK_ANGLE.getColumnIndex());
        return tackAngleDeg == null ? null : new DegreeBearingImpl(tackAngleDeg.doubleValue());
    }

    @Override
    public Bearing getRake() {
        Double rakeDeg = this.fix.get(BravoExtendedSensorDataMetadata.RAKE_DEG.getColumnIndex());
        return rakeDeg == null ? null : new DegreeBearingImpl(rakeDeg.doubleValue());
    }

    @Override
    public Double getDeflectorPercentage() {
        return this.fix.get(BravoExtendedSensorDataMetadata.DEFLECTOR_PERCENTAGE.getColumnIndex());
    }

    @Override
    public Bearing getTargetHeel() {
        Double targetHeelDeg = this.fix.get(BravoExtendedSensorDataMetadata.TARGET_HEEL.getColumnIndex());
        return targetHeelDeg == null ? null : new DegreeBearingImpl(targetHeelDeg.doubleValue());
    }

    @Override
    public Distance getDeflector() {
        Double deflectorMillimeters = this.fix.get(BravoExtendedSensorDataMetadata.DEFLECTOR_MILLIMETERS.getColumnIndex());
        return deflectorMillimeters == null ? null : new MeterDistance(deflectorMillimeters / 1000.0);
    }

    @Override
    public Double getTargetBoatspeedP() {
        return this.fix.get(BravoExtendedSensorDataMetadata.TARGET_BOATSPEED_P.getColumnIndex());
    }

    @Override
    public Double getExpeditionAWA() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_AWA.getColumnIndex());
    }

    @Override
    public Double getExpeditionAWS() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_AWS.getColumnIndex());
    }

    @Override
    public Double getExpeditionTWA() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TWA.getColumnIndex());
    }

    @Override
    public Double getExpeditionTWS() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TWS.getColumnIndex());
    }

    @Override
    public Double getExpeditionTWD() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TWD.getColumnIndex());
    }

    @Override
    public Double getExpeditionBSP() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_BSP.getColumnIndex());
    }

    @Override
    public Double getExpeditionBSP_TR() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_BSP_TR.getColumnIndex());
    }

    @Override
    public Double getExpeditionSOG() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_SOG.getColumnIndex());
    }

    @Override
    public Double getExpeditionCOG() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_COG.getColumnIndex());
    }

    @Override
    public Double getExpeditionForestayLoad() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_FORESTAY.getColumnIndex());
    }

    @Override
    public Double getExpeditionRake() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_RAKE.getColumnIndex());
    }

    @Override
    public Double getExpeditionHDG() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_HDG.getColumnIndex());
    }

    @Override
    public Double getExpeditionHeel() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_HEEL.getColumnIndex());
    }

    @Override
    public Double getExpeditionTG_Heell() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TGHEEL.getColumnIndex());
    }

    @Override
    public Double getExpeditionBARO() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_BARO.getColumnIndex());
    }

    @Override
    public Double getExpeditionLoadP() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_LOAD_P.getColumnIndex());
    }

    @Override
    public Double getExpeditionLoadS() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_LOAD_S.getColumnIndex());
    }

    @Override
    public Double getExpeditionJibCarPort() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_JIB_CAR_PORT.getColumnIndex());
    }

    @Override
    public Double getExpeditionJibCarStbd() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_JIB_CAR_STBD.getColumnIndex());
    }

    @Override
    public Double getExpeditionMastButt() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_MAST_BUTT.getColumnIndex());
    }

    @Override
    public Double getExpeditionTmToGunInSeconds() {
        Double days = this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TMTOGUN.getColumnIndex());
        return days == null ? null : Double.valueOf(days * 24.0 * 3600.0);
    }

    @Override
    public Double getExpeditionTmToBurnInSeconds() {
        Double days = this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_TMTOBURN.getColumnIndex());
        return days == null ? null : Double.valueOf(days * 24.0 * 3600.0);
    }

    @Override
    public Double getExpeditionBelowLnInMeters() {
        Double nauticalMiles = this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_BELOWLN.getColumnIndex());
        return nauticalMiles == null ? null : Double.valueOf(nauticalMiles * 1852.0);
    }

    @Override
    public Double getExpeditionRateOfTurn() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_RATE_OF_TURN.getColumnIndex());
    }

    @Override
    public Double getExpeditionCourse() {
        Double expeditionHDG = this.getExpeditionHDG();
        Bearing leeway = this.getLeeway();
        if (expeditionHDG != null && leeway != null) {
            return expeditionHDG + leeway.getDegrees();
        }
        return null;
    }

    @Override
    public Double getExpeditionKickerTension() {
        return this.fix.get(BravoExtendedSensorDataMetadata.EXPEDITION_KICKER_TENSION.getColumnIndex());
    }
}

