/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.tracking.impl;

import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.tracking.GPSFix;
import com.sap.sailing.domain.common.tracking.impl.AbstractGPSFixImpl;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.AbstractTimePoint;

public abstract class AbstractCompactGPSFixImpl
extends AbstractGPSFixImpl {
    private static final long serialVersionUID = 3943572107870245437L;
    private static final byte IS_VALIDITY_CACHED = 1;
    private static final byte IS_ESTIMATED_SPEED_CACHED = 2;
    private static final byte VALIDITY = 4;
    private final long timePointAsMillis;
    private byte whatIsCached = 0;

    public AbstractCompactGPSFixImpl(TimePoint timePoint) {
        this.timePointAsMillis = timePoint == null ? -1L : timePoint.asMillis();
    }

    public AbstractCompactGPSFixImpl(GPSFix gpsFix) {
        this(gpsFix.getTimePoint());
    }

    public String toString() {
        return this.getTimePoint() + ": " + this.getPosition();
    }

    public TimePoint getTimePoint() {
        return new CompactTimePoint();
    }

    @Override
    public boolean isValidityCached() {
        return (this.whatIsCached & 1) != 0;
    }

    @Override
    public boolean isValidCached() {
        assert (this.isValidityCached());
        return (this.whatIsCached & 4) != 0;
    }

    @Override
    public void invalidateCache() {
        this.whatIsCached = (byte)(this.whatIsCached & 0xFFFFFFFE);
    }

    @Override
    public void cacheValidity(boolean isValid) {
        if (isValid) {
            this.whatIsCached = (byte)(this.whatIsCached | 5);
        } else {
            this.whatIsCached = (byte)(this.whatIsCached | 1);
            this.whatIsCached = (byte)(this.whatIsCached & 0xFFFFFFFB);
        }
    }

    @Override
    public boolean isEstimatedSpeedCached() {
        return (this.whatIsCached & 2) != 0;
    }

    @Override
    public void invalidateEstimatedSpeedCache() {
        this.whatIsCached = (byte)(this.whatIsCached & 0xFFFFFFFD);
    }

    @Override
    public void cacheEstimatedSpeed(SpeedWithBearing estimatedSpeed) {
        this.whatIsCached = (byte)(this.whatIsCached | 2);
    }

    private class CompactTimePoint
    extends AbstractTimePoint
    implements TimePoint {
        private static final long serialVersionUID = -2470922642359937437L;

        private CompactTimePoint() {
        }

        public long asMillis() {
            return AbstractCompactGPSFixImpl.this.timePointAsMillis;
        }
    }
}

