/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.sensordata;

import com.sap.sailing.domain.common.sensordata.ColumnMetadata;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public enum BravoExtendedSensorDataMetadata implements ColumnMetadata
{
    RIDE_HEIGHT_PORT_HULL("RideHeightPort", true),
    RIDE_HEIGHT_STBD_HULL("RideHeightStbd", true),
    HEEL("Heel", true),
    PITCH("PitchRate", true),
    DB_RAKE_PORT("DaggerBoardRakeAnglePort", true),
    DB_RAKE_STBD("DaggerBoardRakeAngleStbd", true),
    RUDDER_RAKE_PORT("RudderRakeAnglePort", true),
    RUDDER_RAKE_STBD("RudderRakeAngleStbd", true),
    MAST_ROTATION("MastRotation", true),
    LEEWAY(null, false),
    SET(null, false),
    DRIFT(null, false),
    DEPTH(null, false),
    RUDDER(null, false),
    FORESTAY_LOAD(null, false),
    FORESTAY_PRESSURE(null, false),
    TACK_ANGLE(null, false),
    RAKE_DEG(null, false),
    DEFLECTOR_PERCENTAGE(null, false),
    TARGET_HEEL(null, false),
    DEFLECTOR_MILLIMETERS(null, false),
    TARGET_BOATSPEED_P(null, false),
    LAT("Lat", true),
    LON("Lon", true),
    COG("COG", true),
    SOG("SOG", true),
    EXPEDITION_AWA(null, false),
    EXPEDITION_AWS(null, false),
    EXPEDITION_TWA(null, false),
    EXPEDITION_TWS(null, false),
    EXPEDITION_TWD(null, false),
    EXPEDITION_BSP(null, false),
    EXPEDITION_BSP_TR(null, false),
    EXPEDITION_SOG(null, false),
    EXPEDITION_COG(null, false),
    EXPEDITION_FORESTAY(null, false),
    EXPEDITION_RAKE(null, false),
    EXPEDITION_HDG(null, false),
    EXPEDITION_HEEL(null, false),
    EXPEDITION_TGHEEL(null, false),
    EXPEDITION_TMTOGUN(null, false),
    EXPEDITION_TMTOBURN(null, false),
    EXPEDITION_BELOWLN(null, false),
    EXPEDITION_BARO(null, false),
    EXPEDITION_LOAD_P(null, false),
    EXPEDITION_LOAD_S(null, false),
    EXPEDITION_JIB_CAR_PORT(null, false),
    EXPEDITION_JIB_CAR_STBD(null, false),
    EXPEDITION_MAST_BUTT(null, false),
    EXPEDITION_RATE_OF_TURN(null, false),
    EXPEDITION_KICKER_TENSION(null, false);

    private final String columnName;
    private final boolean expectedInLogFile;
    public static final int HEADER_COLUMN_OFFSET = 3;

    private BravoExtendedSensorDataMetadata(String columnName, boolean expectedInLogfile) {
        this.columnName = columnName;
        this.expectedInLogFile = expectedInLogfile;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public boolean isExpectedInLogFile() {
        return this.expectedInLogFile;
    }

    @Override
    public int getColumnIndex() {
        return this.ordinal();
    }

    public static BravoExtendedSensorDataMetadata byColumnName(String valueName) {
        BravoExtendedSensorDataMetadata[] values;
        BravoExtendedSensorDataMetadata[] bravoExtendedSensorDataMetadataArray = values = BravoExtendedSensorDataMetadata.values();
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            BravoExtendedSensorDataMetadata item = bravoExtendedSensorDataMetadataArray[n2];
            if (Objects.equals(item.getColumnName(), valueName)) {
                return item;
            }
            ++n2;
        }
        return null;
    }

    public static int getTrackColumnCount() {
        int result = 0;
        BravoExtendedSensorDataMetadata[] bravoExtendedSensorDataMetadataArray = BravoExtendedSensorDataMetadata.values();
        int n = bravoExtendedSensorDataMetadataArray.length;
        int n2 = 0;
        while (n2 < n) {
            BravoExtendedSensorDataMetadata m = bravoExtendedSensorDataMetadataArray[n2];
            if (m.isExpectedInLogFile()) {
                ++result;
            }
            ++n2;
        }
        return result;
    }

    public static Map<String, Integer> getColumnNamesToIndexInDoubleFix() {
        HashMap<String, Integer> columnNamesToIndexInDoubleFix = new HashMap<String, Integer>();
        BravoExtendedSensorDataMetadata[] bravoExtendedSensorDataMetadataArray = BravoExtendedSensorDataMetadata.values();
        int n = bravoExtendedSensorDataMetadataArray.length;
        int n2 = 0;
        while (n2 < n) {
            BravoExtendedSensorDataMetadata column = bravoExtendedSensorDataMetadataArray[n2];
            if (column.isExpectedInLogFile()) {
                columnNamesToIndexInDoubleFix.put(column.getColumnName(), column.getColumnIndex());
            }
            ++n2;
        }
        return columnNamesToIndexInDoubleFix;
    }
}

