/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sailing.domain.common.DoubleTriple;
import com.sap.sailing.domain.common.SpeedWithBearing;
import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.KnotSpeedWithBearingImpl;
import com.sap.sailing.domain.common.impl.RadianBearingImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.common.scalablevalue.ScalableValue;

public class ScalableSpeedWithBearing
implements ScalableValue<DoubleTriple, SpeedWithBearing> {
    private final double speedInKnots;
    private final double sin;
    private final double cos;

    public ScalableSpeedWithBearing(SpeedWithBearing speedWithBearing) {
        this(speedWithBearing.getKnots(), Math.sin(speedWithBearing.getBearing().getRadians()), Math.cos(speedWithBearing.getBearing().getRadians()));
    }

    public ScalableSpeedWithBearing(Speed speed, double sin, double cos) {
        this(speed.getKnots(), sin, cos);
    }

    public ScalableSpeedWithBearing(double speedInKnots, double sin, double cos) {
        this.speedInKnots = speedInKnots;
        this.sin = sin;
        this.cos = cos;
    }

    public ScalableSpeedWithBearing multiply(double factor) {
        return new ScalableSpeedWithBearing(factor * this.speedInKnots, factor * this.sin, factor * this.cos);
    }

    public ScalableSpeedWithBearing add(ScalableValue<DoubleTriple, SpeedWithBearing> t) {
        DoubleTriple tValue = (DoubleTriple)t.getValue();
        return new ScalableSpeedWithBearing(this.speedInKnots + tValue.getA(), this.sin + tValue.getB(), this.cos + tValue.getC());
    }

    public SpeedWithBearing divide(double divisor) {
        KnotSpeedImpl newSpeed = new KnotSpeedImpl(this.speedInKnots / divisor);
        double angle = this.cos == 0.0 ? (this.sin >= 0.0 ? 1.5707963267948966 : -1.5707963267948966) : Math.atan2(this.sin, this.cos);
        RadianBearingImpl bearing = new RadianBearingImpl(angle < 0.0 ? angle + Math.PI * 2 : angle);
        return new KnotSpeedWithBearingImpl(newSpeed.getKnots(), bearing);
    }

    public DoubleTriple getValue() {
        return new DoubleTriple(this.speedInKnots, this.sin, this.cos);
    }
}

