/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sse.common.Speed;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalableSpeed
implements ScalableValueWithDistance<Double, Speed> {
    private final double knots;

    public ScalableSpeed(Speed speed) {
        this.knots = speed.getKnots();
    }

    private ScalableSpeed(double knots) {
        this.knots = knots;
    }

    public ScalableSpeed multiply(double factor) {
        return new ScalableSpeed(factor * this.knots);
    }

    public ScalableSpeed add(ScalableValue<Double, Speed> t) {
        return new ScalableSpeed(this.knots + (Double)t.getValue());
    }

    public Speed divide(double divisor) {
        return new KnotSpeedImpl(this.knots / divisor);
    }

    public Double getValue() {
        return this.knots;
    }

    public double getDistance(Speed other) {
        return Math.abs(this.knots - other.getKnots());
    }
}

