/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.scalablevalue.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.SecondsDurationImpl;
import com.sap.sse.common.scalablevalue.ScalableValue;
import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;

public class ScalableDuration
implements ScalableValueWithDistance<Double, Duration> {
    private final double seconds;

    public ScalableDuration(Duration duration) {
        this.seconds = duration.asSeconds();
    }

    private ScalableDuration(double seconds) {
        this.seconds = seconds;
    }

    public ScalableDuration multiply(double factor) {
        return new ScalableDuration(factor * this.seconds);
    }

    public ScalableDuration add(ScalableValue<Double, Duration> t) {
        return new ScalableDuration(this.seconds + (Double)t.getValue());
    }

    public Duration divide(double divisor) {
        return new SecondsDurationImpl(this.seconds / divisor);
    }

    public Double getValue() {
        return this.seconds;
    }

    public double getDistance(Duration other) {
        return Math.abs(this.seconds - other.asSeconds());
    }

    public String toString() {
        return this.divide(1.0).toString();
    }
}

