/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.quadtree;

import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.BoundsImpl;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sailing.domain.common.quadtree.impl.Node;
import java.io.Serializable;

public class QuadTree<T>
implements Serializable {
    private static final long serialVersionUID = -5500716775749946017L;
    private final Node<T> root;
    private static final int DEFAULT_MAX_NODE_ITEMS = 20;

    public QuadTree() {
        this(new BoundsImpl(new DegreePosition(-90.0, -180.0), new DegreePosition(90.0, 180.0)), 20);
    }

    public QuadTree(Position southWest, Position northEast, int maxItems) {
        this(new BoundsImpl(southWest, northEast), maxItems);
    }

    private QuadTree(Bounds bounds, int maxItems) {
        this.root = new Node(bounds, maxItems);
    }

    public T put(Position point, T obj) {
        return this.root.put(point, obj);
    }

    public T remove(Position point, T obj) {
        return this.root.remove(point);
    }

    public void clear() {
        this.root.clear();
    }

    public T get(Position point) {
        Node.GetResult<T> result = this.root.get(point);
        return result == null ? null : (T)result.getValue();
    }

    public T get(Position point, double withinDistance) {
        Node.GetResult<T> result = this.root.get(point, withinDistance);
        return result == null ? null : (T)result.getValue();
    }

    public Iterable<T> get(Bounds bounds) {
        return this.root.get(bounds);
    }

    public static double getLatLngDistance(Position a, Position b) {
        double dy = a.getLatDeg() - b.getLatDeg();
        double dx = a.getLngDeg() - b.getLngDeg();
        double dxWrapped = Math.abs(dx) <= 180.0 ? dx : 360.0 - Math.abs(dx);
        double distance = Math.sqrt(dy * dy + dxWrapped * dxWrapped);
        return distance;
    }
}

