/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.orc;

import com.sap.sailing.domain.common.impl.KnotSpeedImpl;
import com.sap.sailing.domain.common.impl.NauticalMileDistance;
import com.sap.sse.common.Bearing;
import com.sap.sse.common.CountryCode;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import com.sap.sse.common.Speed;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.WithID;
import com.sap.sse.common.impl.DegreeBearingImpl;
import java.io.Serializable;
import java.util.Map;

public interface ORCCertificate
extends WithID,
Serializable {
    public static final Speed[] ALLOWANCES_TRUE_WIND_SPEEDS = new Speed[]{new KnotSpeedImpl(6.0), new KnotSpeedImpl(8.0), new KnotSpeedImpl(10.0), new KnotSpeedImpl(12.0), new KnotSpeedImpl(14.0), new KnotSpeedImpl(16.0), new KnotSpeedImpl(20.0)};
    public static final Bearing[] ALLOWANCES_TRUE_WIND_ANGLES = new Bearing[]{new DegreeBearingImpl(52.0), new DegreeBearingImpl(60.0), new DegreeBearingImpl(75.0), new DegreeBearingImpl(90.0), new DegreeBearingImpl(110.0), new DegreeBearingImpl(120.0), new DegreeBearingImpl(135.0), new DegreeBearingImpl(150.0)};
    public static final Distance NAUTICAL_MILE = new NauticalMileDistance(1.0);

    public String getId();

    public String getReferenceNumber();

    public String getFileId();

    public CountryCode getIssuingCountry();

    public String getSailNumber();

    public String getBoatClassName();

    public Duration getGPH();

    public double getGPHInSecondsToTheMile();

    public Double getCDL();

    public Distance getLengthOverAll();

    public TimePoint getIssueDate();

    public Map<Speed, Speed> getWindwardLeewardSpeedPrediction();

    public Map<Speed, Speed> getCircularRandomSpeedPredictions();

    public Map<Speed, Speed> getLongDistanceSpeedPredictions();

    public Map<Speed, Speed> getNonSpinnakerSpeedPredictions();

    public Map<Speed, Bearing> getBeatAngles();

    public Map<Speed, Bearing> getRunAngles();

    public Map<Speed, Duration> getBeatAllowances();

    public Map<Speed, Duration> getRunAllowances();

    public Map<Speed, Speed> getBeatVMGPredictions();

    public Map<Speed, Speed> getRunVMGPredictions();

    public Map<Speed, Map<Bearing, Speed>> getVelocityPredictionPerTrueWindSpeedAndAngle();

    public String getBoatName();

    public Speed[] getTrueWindSpeeds();

    public Bearing[] getTrueWindAngles();
}

