/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.Placemark;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sse.common.CountryCodeFactory;
import com.sap.sse.common.Distance;

public class PlacemarkImpl
implements Placemark {
    private static final long serialVersionUID = -7287453946921815463L;
    private String name;
    private String countryCode;
    private Position position;
    private long population;

    PlacemarkImpl() {
    }

    public PlacemarkImpl(String name, String countryCode, Position position, long population) {
        this.name = name;
        this.countryCode = countryCode;
        this.position = position;
        this.population = population;
    }

    public PlacemarkImpl(String name, String countryCode, String countryName, Position position, String type) {
        this(name, countryCode, position, 0L);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getCountryCode() {
        return this.countryCode;
    }

    @Override
    public Position getPosition() {
        return this.position;
    }

    @Override
    public long getPopulation() {
        return this.population;
    }

    @Override
    public Distance distanceFrom(Position position) {
        return this.position.getDistance(position);
    }

    @Override
    public Distance distanceFrom(double latDeg, double lngDeg) {
        DegreePosition p = new DegreePosition(latDeg, lngDeg);
        return this.distanceFrom(p);
    }

    @Override
    public String getCountryName() {
        return CountryCodeFactory.INSTANCE.getFromTwoLetterISOName(this.countryCode).getName();
    }

    public String toString() {
        StringBuilder b = new StringBuilder("[");
        b.append(String.valueOf(this.name) + ", ");
        b.append(String.valueOf(this.countryCode) + ", ");
        b.append(String.valueOf(this.position.toString()) + ", ");
        b.append(String.valueOf(this.population) + "]");
        return b.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.countryCode == null ? 0 : this.countryCode.hashCode());
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (int)(this.population ^ this.population >>> 32);
        result = 31 * result + (this.position == null ? 0 : this.position.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        PlacemarkImpl other = (PlacemarkImpl)obj;
        if (this.countryCode == null ? other.countryCode != null : !this.countryCode.equals(other.countryCode)) {
            return false;
        }
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        if (this.population != other.population) {
            return false;
        }
        return !(this.position == null ? other.position != null : !this.position.equals(other.position));
    }
}

