/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import java.util.HashMap;
import java.util.UUID;

public class DeviceConfigurationQRCodeUtils {
    private static final String BASE_INVITATION_URL = "https://racemanager-app.sapsailing.com/invite";
    public static final String serverUrl = "server_url";
    public static final String eventId = "event_id";
    public static final String courseAreaId = "course_area_uuid";
    public static final String priority = "priority";
    public static final String deviceIdentifierKey = "device_config_identifier";
    public static final String deviceUuidKey = "device_config_uuid";
    public static final String accessTokenKey = "token";

    public static String composeQRContent(String serverUrlWithoutFinalSlash, String urlEncodedDeviceConfigName, String urlEncodedDeviceIdAsString, UUID eventId, UUID courseAreaId, Integer priority, String accessToken) {
        return "https://racemanager-app.sapsailing.com/invite?server_url=" + serverUrlWithoutFinalSlash + "&" + deviceIdentifierKey + "=" + urlEncodedDeviceConfigName + "&" + deviceUuidKey + "=" + urlEncodedDeviceIdAsString + (eventId != null ? "&event_id=" + eventId : "") + (courseAreaId != null ? "&course_area_uuid=" + courseAreaId : "") + (priority != null ? "&priority=" + priority : "") + (accessToken != null ? "&token=" + accessToken : "");
    }

    public static DeviceConfigurationDetails splitQRContent(String qrCodeContent, URLDecoder urlDecoder) {
        int fragmentIndex = qrCodeContent.lastIndexOf(35);
        if (fragmentIndex == -1 || fragmentIndex == 0 || qrCodeContent.length() == fragmentIndex + 1) {
            throw new IllegalArgumentException("There is no server or identifier.");
        }
        String fragment = qrCodeContent.substring(fragmentIndex + 1);
        String[] params = fragment.split("&");
        HashMap<String, String> paramMap = new HashMap<String, String>();
        String[] stringArray = params;
        int n = params.length;
        int n2 = 0;
        while (n2 < n) {
            String param = stringArray[n2];
            String[] keyValue = param.split("=", 2);
            if (keyValue.length == 2) {
                paramMap.put(keyValue[0], urlDecoder.decode(keyValue[1]));
            }
            ++n2;
        }
        if (!paramMap.containsKey(deviceIdentifierKey) && !paramMap.containsKey(deviceUuidKey)) {
            throw new IllegalArgumentException("Device identifier parameter device_config_identifier and device UUID parameter device_config_uuid are both missing from QR code contents");
        }
        String apkUrl = qrCodeContent.substring(0, fragmentIndex);
        return new DeviceConfigurationDetails(apkUrl, paramMap.get(deviceUuidKey) == null ? null : UUID.fromString((String)paramMap.get(deviceUuidKey)), paramMap.get(deviceIdentifierKey) == null ? null : (String)paramMap.get(deviceIdentifierKey), (String)paramMap.get(accessTokenKey));
    }

    public static class DeviceConfigurationDetails {
        private final String url;
        private final String deviceIdentifier;
        private final UUID uuid;
        private final String accessToken;

        public DeviceConfigurationDetails(String url, UUID uuid, String deviceConfigurationName, String accessToken) {
            this.url = url;
            this.uuid = uuid;
            this.deviceIdentifier = deviceConfigurationName;
            this.accessToken = accessToken;
        }

        public String getUrl() {
            return this.url;
        }

        public UUID getUuid() {
            return this.uuid;
        }

        public String getDeviceIdentifier() {
            return this.deviceIdentifier;
        }

        public String getAccessToken() {
            return this.accessToken;
        }
    }

    public static interface URLDecoder {
        public String decode(String var1);
    }
}

