/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.impl;

import com.sap.sailing.domain.common.Bounds;
import com.sap.sailing.domain.common.Position;
import com.sap.sailing.domain.common.impl.DegreePosition;
import com.sap.sse.common.Distance;

public class BoundsImpl
implements Bounds {
    private final Position sw;
    private final Position ne;
    private final boolean crossesDateLine;

    public BoundsImpl(Position sw, Position ne) {
        this.sw = sw;
        this.ne = ne;
        this.crossesDateLine = ne.getLngDeg() < sw.getLngDeg();
    }

    public BoundsImpl(Position position) {
        this(position, position);
    }

    @Override
    public Position getNorthWest() {
        return new DegreePosition(this.getNorthEast().getLatDeg(), this.getSouthWest().getLngDeg());
    }

    @Override
    public Position getSouthEast() {
        return new DegreePosition(this.getSouthWest().getLatDeg(), this.getNorthEast().getLngDeg());
    }

    @Override
    public Position getNorthEast() {
        return this.ne;
    }

    @Override
    public Position getSouthWest() {
        return this.sw;
    }

    private double getDistanceDeg(double west, double east) {
        double diff = east - west;
        double result = this.isCrossingDateLine(west, east) ? 360.0 + diff : diff;
        return result;
    }

    @Override
    public Bounds intersect(Bounds other) {
        double maxSouthLatDeg = Math.max(this.getSouthWest().getLatDeg(), other.getSouthWest().getLatDeg());
        double minNorthLatDeg = Math.min(this.getNorthEast().getLatDeg(), other.getNorthEast().getLatDeg());
        double westDeg = this.containsLngDeg(other.getSouthWest().getLngDeg()) ? other.getSouthWest().getLngDeg() : (other.containsLngDeg(this.getSouthWest().getLngDeg()) ? this.getSouthWest().getLngDeg() : this.getSouthWest().getLngDeg());
        double eastDeg = this.containsLngDeg(other.getNorthEast().getLngDeg()) ? other.getNorthEast().getLngDeg() : (other.containsLngDeg(this.getNorthEast().getLngDeg()) ? this.getNorthEast().getLngDeg() : this.getSouthWest().getLngDeg());
        return new BoundsImpl(new DegreePosition(maxSouthLatDeg, westDeg), new DegreePosition(minNorthLatDeg, eastDeg));
    }

    @Override
    public Bounds union(Bounds other) {
        double minLatDeg = Math.min(this.getSouthWest().getLatDeg(), other.getSouthWest().getLatDeg());
        double maxLatDeg = Math.max(this.getNorthEast().getLatDeg(), other.getNorthEast().getLatDeg());
        double[] west = new double[]{this.getSouthWest().getLngDeg(), other.getSouthWest().getLngDeg()};
        double[] east = new double[]{this.getNorthEast().getLngDeg(), other.getNorthEast().getLngDeg()};
        double minLngDegDistance = Double.MAX_VALUE;
        double bestWest = 0.0;
        double bestEast = 0.0;
        int w = 0;
        while (w < 2) {
            int e = 0;
            while (e < 2) {
                if (this.spansLngDeg(west[w], east[e], west[1 - w]) && this.spansLngDeg(west[w], east[e], east[1 - e])) {
                    double d;
                    double currentLngDegDistance = Math.abs(this.getDistanceDeg(west[w], east[e]));
                    if (d < minLngDegDistance) {
                        minLngDegDistance = currentLngDegDistance;
                        bestWest = west[w];
                        bestEast = east[e];
                    }
                }
                ++e;
            }
            ++w;
        }
        return new BoundsImpl(new DegreePosition(minLatDeg, bestWest), new DegreePosition(maxLatDeg, bestEast));
    }

    @Override
    public Bounds extend(Bounds other) {
        return this.union(other);
    }

    @Override
    public Bounds extend(Position p) {
        return this.union(new BoundsImpl(p, p));
    }

    private boolean spansLngDeg(double westLngDeg, double eastLngDeg, double lngDeg) {
        return this.isCrossingDateLine(westLngDeg, eastLngDeg) ? lngDeg >= westLngDeg && lngDeg <= 180.0 || lngDeg >= -180.0 && lngDeg <= eastLngDeg : westLngDeg <= lngDeg && lngDeg <= eastLngDeg;
    }

    private boolean isCrossingDateLine(double westLngDeg, double eastLngDeg) {
        return westLngDeg > eastLngDeg;
    }

    @Override
    public boolean intersects(Bounds other) {
        return !(!this.containsLatDeg(other.getSouthWest().getLatDeg()) && !this.containsLatDeg(other.getNorthEast().getLatDeg()) && !other.containsLatDeg(this.getSouthWest().getLatDeg()) && !other.containsLatDeg(this.getNorthEast().getLatDeg()) || !this.containsLngDeg(other.getSouthWest().getLngDeg()) && !this.containsLngDeg(other.getNorthEast().getLngDeg()) && !other.containsLngDeg(this.getSouthWest().getLngDeg()) && !other.containsLngDeg(this.getNorthEast().getLngDeg()));
    }

    @Override
    public boolean containsLatDeg(double latDeg) {
        return latDeg >= this.getSouthWest().getLatDeg() && latDeg <= this.getNorthEast().getLatDeg();
    }

    @Override
    public boolean containsLngDeg(double lngDeg) {
        return this.spansLngDeg(this.getSouthWest().getLngDeg(), this.getNorthEast().getLngDeg(), lngDeg);
    }

    @Override
    public boolean contains(Position other) {
        return other.getLatDeg() >= this.getSouthWest().getLatDeg() && other.getLatDeg() <= this.getNorthEast().getLatDeg() && (this.isCrossesDateLine() ? other.getLngDeg() <= 180.0 && other.getLngDeg() >= this.getSouthWest().getLngDeg() || other.getLngDeg() >= -180.0 && other.getLngDeg() <= this.getNorthEast().getLngDeg() : other.getLngDeg() >= this.getSouthWest().getLngDeg() && other.getLngDeg() <= this.getNorthEast().getLngDeg());
    }

    @Override
    public boolean contains(Bounds other) {
        return this.isCrossesDateLine() == other.isCrossesDateLine() && this.contains(other.getNorthEast()) && this.contains(other.getSouthWest());
    }

    @Override
    public boolean isCrossesDateLine() {
        return this.crossesDateLine;
    }

    @Override
    public boolean isEmpty() {
        return this.getSouthWest().getLatDeg() >= this.getNorthEast().getLatDeg() || this.getSouthWest().getLngDeg() == this.getNorthEast().getLngDeg();
    }

    @Override
    public Distance getDiameter() {
        return this.getNorthWest().getDistance(this.getSouthEast());
    }

    public String toString() {
        return "{SW: " + this.getSouthWest().toString() + ", NE: " + this.getNorthEast().toString() + "}";
    }
}

