/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sse.common.Util;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

public class PairingListDTO
implements Serializable {
    private static final long serialVersionUID = 102220422437194196L;
    private List<List<List<Util.Pair<CompetitorDTO, BoatDTO>>>> pairingList;
    private List<BoatDTO> boats;
    private List<String> raceColumnNames;

    public PairingListDTO() {
    }

    public PairingListDTO(List<List<List<Util.Pair<CompetitorDTO, BoatDTO>>>> result) {
        this(result, null);
    }

    public PairingListDTO(List<List<List<Util.Pair<CompetitorDTO, BoatDTO>>>> result, List<String> raceColumnNames) {
        this.pairingList = result;
        this.raceColumnNames = raceColumnNames;
    }

    public List<List<List<Util.Pair<CompetitorDTO, BoatDTO>>>> getPairingList() {
        return this.pairingList;
    }

    public List<BoatDTO> getBoats() {
        if (this.boats == null) {
            this.boats = new ArrayList<BoatDTO>();
            for (List<Util.Pair<CompetitorDTO, BoatDTO>> fleet : this.pairingList.get(0)) {
                for (Util.Pair<CompetitorDTO, BoatDTO> competitorAndBoatPair : fleet) {
                    if (this.boats.contains(competitorAndBoatPair.getB())) continue;
                    this.boats.add((BoatDTO)competitorAndBoatPair.getB());
                }
            }
        }
        return this.boats;
    }

    public void setBoats(List<BoatDTO> boats) {
        this.boats = boats;
    }

    public List<String> getRaceColumnNames() {
        return this.raceColumnNames;
    }
}

