/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.BoatDTO;
import com.sap.sailing.domain.common.dto.CompetitorDTO;
import com.sap.sailing.domain.common.dto.LeaderboardEntryDTO;
import com.sap.sse.common.Distance;
import com.sap.sse.common.Duration;
import java.io.Serializable;
import java.util.Date;
import java.util.Map;

public class LeaderboardRowDTO
implements Serializable {
    private static final long serialVersionUID = -5421934148931661900L;
    public CompetitorDTO competitor;
    public BoatDTO boat;
    public Map<String, LeaderboardEntryDTO> fieldsByRaceColumnName;
    public Double carriedPoints;
    public Double netPoints;
    public Double totalTimeSailedInSeconds;
    public Double totalTimeSailedDownwindInSeconds;
    public Double maximumSpeedOverGroundInKnots;
    public Date whenMaximumSpeedOverGroundWasAchieved;
    public Double totalTimeSailedUpwindInSeconds;
    public Double totalTimeSailedReachingInSeconds;
    public Double totalDistanceTraveledInMeters;
    public Double totalDurationFoiledInSeconds;
    public Double totalDistanceFoiledInMeters;
    public Integer totalScoredRaces;
    public Double effectiveTimeOnTimeFactor;
    public Duration effectiveTimeOnDistanceAllowancePerNauticalMile;

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.boat == null ? 0 : this.boat.hashCode());
        result = 31 * result + (this.carriedPoints == null ? 0 : this.carriedPoints.hashCode());
        result = 31 * result + (this.competitor == null ? 0 : this.competitor.hashCode());
        result = 31 * result + (this.fieldsByRaceColumnName == null ? 0 : this.fieldsByRaceColumnName.hashCode());
        result = 31 * result + (this.maximumSpeedOverGroundInKnots == null ? 0 : this.maximumSpeedOverGroundInKnots.hashCode());
        result = 31 * result + (this.netPoints == null ? 0 : this.netPoints.hashCode());
        result = 31 * result + (this.effectiveTimeOnDistanceAllowancePerNauticalMile == null ? 0 : this.effectiveTimeOnDistanceAllowancePerNauticalMile.hashCode());
        result = 31 * result + (this.effectiveTimeOnTimeFactor == null ? 0 : this.effectiveTimeOnTimeFactor.hashCode());
        result = 31 * result + (this.totalDistanceFoiledInMeters == null ? 0 : this.totalDistanceFoiledInMeters.hashCode());
        result = 31 * result + (this.totalDistanceTraveledInMeters == null ? 0 : this.totalDistanceTraveledInMeters.hashCode());
        result = 31 * result + (this.totalDurationFoiledInSeconds == null ? 0 : this.totalDurationFoiledInSeconds.hashCode());
        result = 31 * result + (this.totalScoredRaces == null ? 0 : this.totalScoredRaces.hashCode());
        result = 31 * result + (this.totalTimeSailedDownwindInSeconds == null ? 0 : this.totalTimeSailedDownwindInSeconds.hashCode());
        result = 31 * result + (this.totalTimeSailedInSeconds == null ? 0 : this.totalTimeSailedInSeconds.hashCode());
        result = 31 * result + (this.totalTimeSailedReachingInSeconds == null ? 0 : this.totalTimeSailedReachingInSeconds.hashCode());
        result = 31 * result + (this.totalTimeSailedUpwindInSeconds == null ? 0 : this.totalTimeSailedUpwindInSeconds.hashCode());
        result = 31 * result + (this.whenMaximumSpeedOverGroundWasAchieved == null ? 0 : this.whenMaximumSpeedOverGroundWasAchieved.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        LeaderboardRowDTO other = (LeaderboardRowDTO)obj;
        if (this.boat == null ? other.boat != null : !this.boat.equals(other.boat)) {
            return false;
        }
        if (this.carriedPoints == null ? other.carriedPoints != null : !this.carriedPoints.equals(other.carriedPoints)) {
            return false;
        }
        if (this.competitor == null ? other.competitor != null : !this.competitor.equals(other.competitor)) {
            return false;
        }
        if (this.fieldsByRaceColumnName == null ? other.fieldsByRaceColumnName != null : !this.fieldsByRaceColumnName.equals(other.fieldsByRaceColumnName)) {
            return false;
        }
        if (this.maximumSpeedOverGroundInKnots == null ? other.maximumSpeedOverGroundInKnots != null : !this.maximumSpeedOverGroundInKnots.equals(other.maximumSpeedOverGroundInKnots)) {
            return false;
        }
        if (this.netPoints == null ? other.netPoints != null : !this.netPoints.equals(other.netPoints)) {
            return false;
        }
        if (this.effectiveTimeOnDistanceAllowancePerNauticalMile == null ? other.effectiveTimeOnDistanceAllowancePerNauticalMile != null : !this.effectiveTimeOnDistanceAllowancePerNauticalMile.equals(other.effectiveTimeOnDistanceAllowancePerNauticalMile)) {
            return false;
        }
        if (this.effectiveTimeOnTimeFactor == null ? other.effectiveTimeOnTimeFactor != null : !this.effectiveTimeOnTimeFactor.equals(other.effectiveTimeOnTimeFactor)) {
            return false;
        }
        if (this.totalDistanceFoiledInMeters == null ? other.totalDistanceFoiledInMeters != null : !this.totalDistanceFoiledInMeters.equals(other.totalDistanceFoiledInMeters)) {
            return false;
        }
        if (this.totalDistanceTraveledInMeters == null ? other.totalDistanceTraveledInMeters != null : !this.totalDistanceTraveledInMeters.equals(other.totalDistanceTraveledInMeters)) {
            return false;
        }
        if (this.totalDurationFoiledInSeconds == null ? other.totalDurationFoiledInSeconds != null : !this.totalDurationFoiledInSeconds.equals(other.totalDurationFoiledInSeconds)) {
            return false;
        }
        if (this.totalScoredRaces == null ? other.totalScoredRaces != null : !this.totalScoredRaces.equals(other.totalScoredRaces)) {
            return false;
        }
        if (this.totalTimeSailedDownwindInSeconds == null ? other.totalTimeSailedDownwindInSeconds != null : !this.totalTimeSailedDownwindInSeconds.equals(other.totalTimeSailedDownwindInSeconds)) {
            return false;
        }
        if (this.totalTimeSailedInSeconds == null ? other.totalTimeSailedInSeconds != null : !this.totalTimeSailedInSeconds.equals(other.totalTimeSailedInSeconds)) {
            return false;
        }
        if (this.totalTimeSailedReachingInSeconds == null ? other.totalTimeSailedReachingInSeconds != null : !this.totalTimeSailedReachingInSeconds.equals(other.totalTimeSailedReachingInSeconds)) {
            return false;
        }
        if (this.totalTimeSailedUpwindInSeconds == null ? other.totalTimeSailedUpwindInSeconds != null : !this.totalTimeSailedUpwindInSeconds.equals(other.totalTimeSailedUpwindInSeconds)) {
            return false;
        }
        return !(this.whenMaximumSpeedOverGroundWasAchieved == null ? other.whenMaximumSpeedOverGroundWasAchieved != null : !this.whenMaximumSpeedOverGroundWasAchieved.equals(other.whenMaximumSpeedOverGroundWasAchieved));
    }

    public Distance getDistanceTraveled(String raceColumnName) {
        LeaderboardEntryDTO fieldsForRace = this.fieldsByRaceColumnName.get(raceColumnName);
        Distance result = fieldsForRace != null ? fieldsForRace.getDistanceTraveled() : null;
        return result;
    }

    public Duration getTimeSailed(String raceColumnName) {
        LeaderboardEntryDTO fieldsForRace = this.fieldsByRaceColumnName.get(raceColumnName);
        Duration result = fieldsForRace != null ? fieldsForRace.getTimeSailed() : null;
        return result;
    }

    public Distance getDistanceFoiled(String raceColumnName) {
        LeaderboardEntryDTO fieldsForRace = this.fieldsByRaceColumnName.get(raceColumnName);
        Distance result = fieldsForRace != null ? fieldsForRace.getDistanceFoiled() : null;
        return result;
    }

    public Duration getDurationFoiled(String raceColumnName) {
        LeaderboardEntryDTO fieldsForRace = this.fieldsByRaceColumnName.get(raceColumnName);
        Duration result = fieldsForRace != null ? fieldsForRace.getDurationFoiled() : null;
        return result;
    }

    public String toString() {
        return "LeaderboardRowDTO for competitor " + this.competitor;
    }
}

