/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.dto;

import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sailing.domain.common.racelog.tracking.MappableToDevice;
import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.Color;
import com.sap.sse.common.WithID;
import com.sap.sse.security.shared.HasPermissions;
import com.sap.sse.security.shared.QualifiedObjectIdentifier;
import com.sap.sse.security.shared.TypeRelativeObjectIdentifier;
import com.sap.sse.security.shared.dto.NamedSecuredObjectDTO;
import com.sap.sse.security.shared.dto.SecuredDTO;
import java.io.Serializable;

public class BoatDTO
extends NamedSecuredObjectDTO
implements WithID,
Serializable,
MappableToDevice,
SecuredDTO {
    private static final long serialVersionUID = -4076992788294272162L;
    private String idAsString;
    private BoatClassDTO boatClass;
    private String sailId;
    private Color color;

    public BoatDTO() {
        super("");
    }

    public BoatDTO(String idAsString, String name, BoatClassDTO boatClass, String sailId) {
        this(idAsString, name, boatClass, sailId, null);
    }

    public BoatDTO(String idAsString, String name, BoatClassDTO boatClass, String sailId, Color color) {
        super(name);
        this.idAsString = idAsString;
        this.boatClass = boatClass;
        this.sailId = sailId;
        this.color = color;
    }

    public Color getColor() {
        return this.color;
    }

    public String getSailId() {
        return this.sailId;
    }

    @Override
    public String getIdAsString() {
        return this.idAsString;
    }

    public Serializable getId() {
        return this.getIdAsString();
    }

    public BoatClassDTO getBoatClass() {
        return this.boatClass;
    }

    public void setBoatClass(BoatClassDTO boatClass) {
        this.boatClass = boatClass;
    }

    public String getDisplayName() {
        boolean hasSailId;
        StringBuilder sb = new StringBuilder();
        boolean bl = hasSailId = this.sailId != null && !this.sailId.isEmpty();
        if (this.getName() != null) {
            sb.append(this.getName());
            if (hasSailId) {
                sb.append(" (").append(this.sailId).append(')');
            }
        } else if (hasSailId) {
            sb.append(this.sailId);
        } else {
            sb.append(this.idAsString);
        }
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = super.hashCode();
        result = 31 * result + (this.boatClass == null ? 0 : this.boatClass.hashCode());
        result = 31 * result + (this.idAsString == null ? 0 : this.idAsString.hashCode());
        result = 31 * result + (this.color == null ? 0 : this.color.hashCode());
        result = 31 * result + (this.sailId == null ? 0 : this.sailId.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!super.equals(obj)) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        BoatDTO other = (BoatDTO)obj;
        if (this.boatClass == null ? other.boatClass != null : !this.boatClass.equals(other.boatClass)) {
            return false;
        }
        if (this.idAsString == null ? other.idAsString != null : !this.idAsString.equals(other.idAsString)) {
            return false;
        }
        if (this.color == null ? other.color != null : !this.color.equals(other.color)) {
            return false;
        }
        return !(this.sailId == null ? other.sailId != null : !this.sailId.equals(other.sailId));
    }

    public String toString() {
        return "BoatDTO [idAsString=" + this.idAsString + ", boatClass=" + this.boatClass + ", sailId=" + this.sailId + ", color=" + this.color + "]";
    }

    public HasPermissions getPermissionType() {
        return SecuredDomainType.BOAT;
    }

    public QualifiedObjectIdentifier getIdentifier() {
        return this.getPermissionType().getQualifiedObjectIdentifier(this.getTypeRelativeObjectIdentifier());
    }

    public TypeRelativeObjectIdentifier getTypeRelativeObjectIdentifier() {
        return new TypeRelativeObjectIdentifier(new String[]{this.idAsString});
    }
}

