/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.DoubleTriple;
import com.sap.sailing.domain.common.Wind;
import com.sap.sailing.domain.common.confidence.impl.LazyDividedScaledPosition;
import com.sap.sailing.domain.common.impl.WindImpl;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalablePosition;
import com.sap.sailing.domain.common.scalablevalue.impl.ScalableSpeedWithBearing;
import com.sap.sse.common.TimePoint;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import com.sap.sse.common.scalablevalue.ScalableValue;

public class ScalableWind
implements ScalableValue<ScalableWind, Wind> {
    private final boolean scalablePositionNull;
    private final double scalablePositionX;
    private final double scalablePositionY;
    private final double scalablePositionZ;
    private final double scaledTimePointSumInMilliseconds;
    private final double speedWithBearingValueA;
    private final double speedWithBearingValueB;
    private final double speedWithBearingValueC;
    private final boolean useSpeed;

    public ScalableWind(Wind wind, boolean useSpeed) {
        this(wind.getPosition() == null ? null : new ScalablePosition(wind.getPosition()), wind.getTimePoint().asMillis(), new ScalableSpeedWithBearing(wind), useSpeed);
    }

    private ScalableWind(ScalablePosition scalablePosition, double scaledTimePointSumInMilliseconds, ScalableSpeedWithBearing scalableSpeedWithBearing, boolean useSpeed) {
        if (scalablePosition == null) {
            this.scalablePositionNull = true;
            this.scalablePositionX = 0.0;
            this.scalablePositionY = 0.0;
            this.scalablePositionZ = 0.0;
        } else {
            this.scalablePositionNull = false;
            DoubleTriple scalablePositionTriple = scalablePosition.getValueAsTriple();
            this.scalablePositionX = scalablePositionTriple.getA();
            this.scalablePositionY = scalablePositionTriple.getB();
            this.scalablePositionZ = scalablePositionTriple.getC();
        }
        this.scaledTimePointSumInMilliseconds = scaledTimePointSumInMilliseconds;
        DoubleTriple scalableSpeedWithBearingTriple = scalableSpeedWithBearing.getValue();
        this.speedWithBearingValueA = scalableSpeedWithBearingTriple.getA();
        this.speedWithBearingValueB = scalableSpeedWithBearingTriple.getB();
        this.speedWithBearingValueC = scalableSpeedWithBearingTriple.getC();
        this.useSpeed = useSpeed;
    }

    public boolean useSpeed() {
        return this.useSpeed;
    }

    public ScalableWind multiply(double factor) {
        return new ScalableWind(this.getScalablePosition() == null ? null : this.getScalablePosition().multiply(factor), factor * this.scaledTimePointSumInMilliseconds, this.getScalableSpeedWithBearing().multiply(factor), this.useSpeed);
    }

    public ScalableWind add(ScalableValue<ScalableWind, Wind> t) {
        ScalablePosition scalablePosition = this.getScalablePosition();
        ScalablePosition tValueScalablePosition = ((ScalableWind)t.getValue()).getScalablePosition();
        return new ScalableWind(scalablePosition == null ? tValueScalablePosition : scalablePosition.add((ScalableValue)tValueScalablePosition), this.scaledTimePointSumInMilliseconds + ((ScalableWind)t.getValue()).scaledTimePointSumInMilliseconds, (ScalableSpeedWithBearing)this.getScalableSpeedWithBearing().add(((ScalableWind)t.getValue()).getScalableSpeedWithBearing()), this.useSpeed || ((ScalableWind)t.getValue()).useSpeed);
    }

    public ScalableWind getValue() {
        return this;
    }

    public Wind divide(double divisor) {
        return new WindImpl(this.getScalablePosition() == null ? null : new LazyDividedScaledPosition(this.getScalablePosition(), divisor), (TimePoint)new MillisecondsTimePoint((long)(this.scaledTimePointSumInMilliseconds / divisor)), this.getScalableSpeedWithBearing().divide(divisor));
    }

    private ScalableSpeedWithBearing getScalableSpeedWithBearing() {
        return new ScalableSpeedWithBearing(this.speedWithBearingValueA, this.speedWithBearingValueB, this.speedWithBearingValueC);
    }

    private ScalablePosition getScalablePosition() {
        return this.scalablePositionNull ? null : new ScalablePosition(this.scalablePositionX, this.scalablePositionY, this.scalablePositionZ);
    }
}

