/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common.confidence.impl;

import com.sap.sailing.domain.common.confidence.Weigher;
import com.sap.sse.common.TimePoint;

public class HyperbolicSquaredTimeDifferenceWeigher
implements Weigher<TimePoint> {
    private static final long serialVersionUID = 4378168079868145134L;
    private final long halfConfidenceAfterMilliseconds;

    public HyperbolicSquaredTimeDifferenceWeigher(long halfConfidenceAfterMilliseconds) {
        this.halfConfidenceAfterMilliseconds = halfConfidenceAfterMilliseconds;
    }

    @Override
    public double getConfidence(TimePoint fix, TimePoint request) {
        double c;
        double x = Math.abs(fix.asMillis() - request.asMillis());
        double y = c = (double)(this.halfConfidenceAfterMilliseconds * this.halfConfidenceAfterMilliseconds);
        return c / (x * x + y);
    }
}

