/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sse.common.Util;
import java.util.Date;

public class RaceTimesCalculationUtil {
    public static final long MIN_TIME_BEFORE_RACE_START = 180000L;
    public static final long MIN_TIME_AFTER_RACE_START = 300000L;
    public static final long TIME_AFTER_LIVE = 300000L;
    public static final long MAX_TIME_AFTER_RACE_END = 180000L;

    public static Util.Pair<Date, Date> calculateRaceMinMax(Date liveTimePoint, Date startOfTracking, Date startOfRace, Date raceFinishingTime, Date raceFinishedTime, Date endOfRace, Date endOfTracking) {
        return RaceTimesCalculationUtil.calculateRaceMinMax(liveTimePoint, startOfTracking, startOfRace, raceFinishingTime, raceFinishedTime, endOfRace, endOfTracking, 180000L, 180000L, 300000L);
    }

    public static Util.Pair<Date, Date> calculateRaceMinMax(Date liveTimePoint, Date startOfTracking, Date startOfRace, Date raceFinishingTime, Date raceFinishedTime, Date endOfRace, Date endOfTracking, long millisBeforeStart, long millisAfterEnd, long millisAfterLive) {
        if (liveTimePoint == null) {
            return new Util.Pair(null, null);
        }
        Date min = null;
        Date max = null;
        if (startOfRace != null) {
            min = new Date(startOfRace.getTime() - millisBeforeStart);
        } else if (startOfTracking != null) {
            min = startOfTracking;
        }
        if (min == null || liveTimePoint.before(min)) {
            min = new Date(liveTimePoint.getTime());
        }
        max = raceFinishedTime != null ? new Date(raceFinishedTime.getTime() + millisAfterEnd) : (endOfRace != null && raceFinishingTime == null ? new Date(endOfRace.getTime() + millisAfterEnd) : (endOfTracking != null && raceFinishingTime == null && liveTimePoint.after(endOfTracking) ? endOfTracking : new Date(liveTimePoint.getTime() + millisAfterLive)));
        return new Util.Pair((Object)min, (Object)max);
    }
}

