/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.BoatClassMasterdata;
import com.sap.sailing.domain.common.dto.BoatClassDTO;
import com.sap.sse.common.Util;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class FuzzyBoatClassNameMatcher {
    public Map<Util.Pair<String, Util.Pair<String, Date>>, Double> sortOfficialResultsByRelevance(final BoatClassDTO boatClass, List<Util.Pair<String, Util.Pair<String, Date>>> eventNameBoatClassNameCapturedWhen, final String leaderboardName) {
        final HashMap<Util.Pair<String, Util.Pair<String, Date>>, Double> qualityOfBoatClassMatch = new HashMap<Util.Pair<String, Util.Pair<String, Date>>, Double>();
        if (eventNameBoatClassNameCapturedWhen.size() == 1) {
            qualityOfBoatClassMatch.computeIfAbsent(eventNameBoatClassNameCapturedWhen.iterator().next(), o -> this.getQualityOfBoatClassMatch(boatClass, (String)((Util.Pair)o.getB()).getA()));
        } else {
            Collections.sort(eventNameBoatClassNameCapturedWhen, new Comparator<Util.Pair<String, Util.Pair<String, Date>>>(){

                @Override
                public int compare(Util.Pair<String, Util.Pair<String, Date>> o1, Util.Pair<String, Util.Pair<String, Date>> o2) {
                    double quality2;
                    int result = 0;
                    double quality1 = qualityOfBoatClassMatch.computeIfAbsent(o1, o -> FuzzyBoatClassNameMatcher.this.getQualityOfBoatClassMatch(boatClass, (String)((Util.Pair)o.getB()).getA()));
                    if (Math.max(quality1, quality2 = qualityOfBoatClassMatch.computeIfAbsent(o2, o -> FuzzyBoatClassNameMatcher.this.getQualityOfBoatClassMatch(boatClass, (String)((Util.Pair)o.getB()).getA())).doubleValue()) >= 0.5) {
                        result = -Double.compare(quality1, quality2);
                    }
                    if (result == 0 && leaderboardName != null) {
                        double quality1BasedOnLeaderboardName = FuzzyBoatClassNameMatcher.this.getQualityOfBoatClassMatch((String)((Util.Pair)o1.getB()).getA(), leaderboardName);
                        double quality2BasedOnLeaderboardName = FuzzyBoatClassNameMatcher.this.getQualityOfBoatClassMatch((String)((Util.Pair)o2.getB()).getA(), leaderboardName);
                        result = -Double.compare(quality1BasedOnLeaderboardName, quality2BasedOnLeaderboardName);
                    }
                    if (result == 0) {
                        result = ((Date)((Util.Pair)o2.getB()).getB()).compareTo((Date)((Util.Pair)o1.getB()).getB());
                    }
                    return result;
                }
            });
        }
        return qualityOfBoatClassMatch;
    }

    private double getQualityOfBoatClassMatch(String leaderboardName, String boatClassNameCandidate) {
        return this.getQualityOfBoatClassMatch(boatClassNameCandidate, Collections.singleton(leaderboardName));
    }

    private double getQualityOfBoatClassMatch(BoatClassDTO boatClassToMatch, String boatClassNameCandidate) {
        BoatClassMasterdata boatClassMasterdata = BoatClassMasterdata.resolveBoatClass(boatClassToMatch.getName());
        HashSet<String> allNamesToMatchAgainst = new HashSet<String>();
        if (boatClassMasterdata != null) {
            allNamesToMatchAgainst.add(boatClassMasterdata.getDisplayName());
            allNamesToMatchAgainst.addAll(Arrays.asList(boatClassMasterdata.getAlternativeNames()));
        } else {
            allNamesToMatchAgainst.add(boatClassToMatch.getName());
        }
        return this.getQualityOfBoatClassMatch(boatClassNameCandidate, allNamesToMatchAgainst);
    }

    private double getQualityOfBoatClassMatch(String boatClassNameCandidate, Iterable<String> allNamesToMatchAgainst) {
        double longestCommonSubstringShareSoFar = 0.0;
        String lowercaseBoatClassNameCandidate = boatClassNameCandidate.toLowerCase();
        for (String boatClassNameToMatch : allNamesToMatchAgainst) {
            String lowerClassBoatClassNameToMatch = boatClassNameToMatch.toLowerCase();
            longestCommonSubstringShareSoFar = Math.max((double)this.getLengthOfLongestCommonSubstringBasedOnLettersAndNumbersOnly(lowerClassBoatClassNameToMatch, lowercaseBoatClassNameCandidate) / (double)lowerClassBoatClassNameToMatch.length(), longestCommonSubstringShareSoFar);
        }
        return longestCommonSubstringShareSoFar;
    }

    private int getLengthOfLongestCommonSubstringBasedOnLettersAndNumbersOnly(String lowerBoatClassNameToMatch, String lowercaseBoatClassNameCandidate) {
        String lowerBoatClassNameToMatchLettersAndNumbersOnly = lowerBoatClassNameToMatch.replaceAll("[^a-zA-Z0-9]*", "");
        String lowercaseBoatClassNameCandidateLettersAndNumbersOnly = lowercaseBoatClassNameCandidate.replaceAll("[^a-zA-Z0-9]*", "");
        return Util.getLengthOfLongestCommonSubstring((String)lowerBoatClassNameToMatchLettersAndNumbersOnly, (String)lowercaseBoatClassNameCandidateLettersAndNumbersOnly);
    }
}

