/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sailing.domain.common;

import com.sap.sailing.domain.common.security.SecuredDomainType;
import com.sap.sse.common.ColorMapper;
import com.sap.sse.common.SortingOrder;
import com.sap.sse.security.shared.HasPermissions;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;

public enum DetailType implements Serializable,
HasPermissions.SecuredEnum
{
    LEG_TACKTYPE_LONGTACK_SHORTTACK(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "TACKTYPE"),
    LEG_DISTANCE_TRAVELED(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "DISTANCE_TRAVELED"),
    LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "DISTANCE_TRAVELED_INCLUDING_GATE_START"),
    LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "AVERAGE_SPEED_OVER_GROUND_IN_KNOTS"),
    RACE_RANK(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    REGATTA_RANK(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    OVERALL_RANK(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    LEG_RANK_GAIN(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "RANK_GAIN"),
    NUMBER_OF_MANEUVERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_SPEED_OVER_GROUND_IN_KNOTS"),
    BRAVO_LEG_CURRENT_HEEL_IN_DEGREES(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_HEEL_IN_DEGREES"),
    BRAVO_LEG_CURRENT_PITCH_IN_DEGREES(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_PITCH_IN_DEGREES"),
    BRAVO_LEG_CURRENT_RIDE_HEIGHT_IN_METERS(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_RIDE_HEIGHT_IN_METERS"),
    BRAVOEXTENDED_LEG_CURRENT_DISTANCE_FOILED_IN_METERS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DISTANCE_FOILED_IN_METERS"),
    BRAVOEXTENDED_LEG_CURRENT_DURATION_FOILED_IN_SECONDS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DURATION_FOILED_IN_SECONDS"),
    BRAVOEXTENDED_RACE_CURRENT_PORT_DAGGERBOARD_RAKE(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_PORT_DAGGERBOARD_RAKE"),
    BRAVOEXTENDED_RACE_CURRENT_STBD_DAGGERBOARD_RAKE(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_STBD_DAGGERBOARD_RAKE"),
    BRAVOEXTENDED_RACE_CURRENT_PORT_RUDDER_RAKE(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_PORT_RUDDER_RAKE"),
    BRAVOEXTENDED_RACE_CURRENT_STBD_RUDDER_RAKE(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_STBD_RUDDER_RAKE"),
    BRAVOEXTENDED_RACE_CURRENT_MAST_ROTATION_IN_DEGREES(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_MAST_ROTATION_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_LEEWAY_IN_DEGREES(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_LEEWAY_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_SET(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_SET"),
    BRAVOEXTENDED_RACE_CURRENT_DRIFT_IN_DEGREES(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DRIFT_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_DEPTH_IN_METERS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DEPTH_IN_METERS"),
    BRAVOEXTENDED_RACE_CURRENT_RUDDER_IN_DEGREES(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_RUDDER_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_TACK_ANGLE_IN_DEGREES(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_TACK_ANGLE_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_PERCENTAGE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DEFLECTOR_PERCENTAGE"),
    BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_IN_MILLIMETERS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_DEFLECTOR_IN_MILLIMETERS"),
    BRAVOEXTENDED_RACE_CURRENT_RAKE_IN_DEGREES(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_RAKE_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_TARGET_HEEL_ANGLE_IN_DEGREES(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_TARGET_HEEL_ANGLE_IN_DEGREES"),
    BRAVOEXTENDED_RACE_CURRENT_FORESTAY_LOAD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_FORESTAY_LOAD"),
    BRAVOEXTENDED_RACE_CURRENT_FORESTAY_PRESSURE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_FORESTAY_PRESSURE"),
    BRAVOEXTENDED_RACE_CURRENT_TARGET_BOATSPEED_PERCENTAGE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_TARGET_BOATSPEED_PERCENTAGE"),
    LEG_ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS"),
    LEG_VELOCITY_MADE_GOOD_IN_KNOTS(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "VELOCITY_MADE_GOOD_IN_KNOTS"),
    LEG_GAP_TO_LEADER_IN_SECONDS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "GAP_TO_LEADER_IN_SECONDS"),
    LEG_GAP_TO_LEADER_IN_SECONDS_CHANGE(2, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "GAP_TO_LEADER_IN_SECONDS_CHANGE"),
    LEG_GAP_CHANGE_SINCE_LEG_START_IN_SECONDS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "GAP_CHANGE_SINCE_LEG_START_IN_SECONDS"),
    LEG_SIDE_TO_WHICH_MARK_AT_LEG_START_WAS_ROUNDED(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "SIDE_TO_WHICH_MARK_AT_LEG_START_WAS_ROUNDED"),
    LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "WINDWARD_DISTANCE_TO_GO_IN_METERS"),
    LEG_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS"),
    LEG_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS"),
    LEG_CURRENT_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    LEG_CURRENT_SIGNED_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_DISTANCE_TRAVELED(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_DISTANCE_TRAVELED_INCLUDING_GATE_START(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_GAP_TO_LEADER_IN_SECONDS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_CHANGE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    START_TACK(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    DISTANCE_TO_START_AT_RACE_START(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    TIME_BETWEEN_RACE_START_AND_COMPETITOR_START(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    SPEED_OVER_GROUND_AT_RACE_START(1, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    SPEED_OVER_GROUND_WHEN_PASSING_START(1, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    DISTANCE_TO_STARBOARD_END_OF_STARTLINE_WHEN_PASSING_START_IN_METERS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    TACK(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    JIBE(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    PENALTY_CIRCLE(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    AVERAGE_MANEUVER_LOSS_IN_METERS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    AVERAGE_TACK_LOSS_IN_METERS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    AVERAGE_JIBE_LOSS_IN_METERS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CURRENT_LEG(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CURRENT_LEG"),
    RACE_DISPLAY_LEGS(0, SortingOrder.NONE, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "DISPLAY_LEGS"),
    RACE_DISPLAY_BOATS(0, SortingOrder.NONE, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    LEG_TIME_TRAVELED(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TIME_TRAVELED"),
    LEG_CORRECTED_TIME_TRAVELED(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "CORRECTED_TIME_TRAVELED"),
    TOTAL_TIME_SAILED_DOWNWIND_IN_SECONDS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    TOTAL_TIME_SAILED_UPWIND_IN_SECONDS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    TOTAL_TIME_SAILED_REACHING_IN_SECONDS(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS(1, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS"),
    OVERALL_TIME_ON_TIME_FACTOR(4, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TIME_ON_TIME_FACTOR"),
    OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE"),
    OVERALL_TOTAL_DISTANCE_TRAVELED(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_DISTANCE_TRAVELED"),
    OVERALL_TOTAL_AVERAGE_SPEED_OVER_GROUND(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_AVERAGE_SPEED_OVER_GROUND"),
    OVERALL_TOTAL_TIME_SAILED_IN_SECONDS(1, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_TIME_SAILED_IN_SECONDS"),
    OVERALL_TOTAL_DURATION_FOILED_IN_SECONDS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_DURATION_FOILED_IN_SECONDS"),
    OVERALL_TOTAL_DISTANCE_FOILED_IN_METERS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_DISTANCE_FOILED_IN_METERS"),
    RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.LINEAR, new String[0]),
    RACE_CURRENT_POSITION_LAT_DEG(10, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CURRENT_POSITION_LNG_DEG(10, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    BRAVO_RACE_CURRENT_RIDE_HEIGHT_IN_METERS(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CURRENT_DISTANCE_FOILED_IN_METERS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CURRENT_DURATION_FOILED_IN_SECONDS(0, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_NET_POINTS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    REGATTA_NET_POINTS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    REGATTA_NET_POINTS_SUM(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_RATIO_BETWEEN_TIME_SINCE_LAST_POSITION_FIX_AND_AVERAGE_SAMPLING_INTERVAL(1, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_DISTANCE_TO_START_FIVE_SECONDS_BEFORE_RACE_START(1, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_SPEED_OVER_GROUND_FIVE_SECONDS_BEFORE_START(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CALCULATED_TIME_TRAVELED(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_IMPLIED_WIND(5, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_CALCULATED_TIME_AT_ESTIMATED_ARRIVAL_AT_COMPETITOR_FARTHEST_AHEAD(0, SortingOrder.ASCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_TIME_TRAVELED(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_TIME_TRAVELED_UPWIND(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_TIME_TRAVELED_DOWNWIND(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    RACE_TIME_TRAVELED_REACHING(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    CHART_DISTANCE_TO_START_LINE(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "DISTANCE_TO_START_LINE"),
    CHART_BEAT_ANGLE(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "BEAT_ANGLE"),
    CHART_ABS_TWA(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    CHART_COURSE_OVER_GROUND_TRUE_DEGREES(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.LINEAR, "COURSE_OVER_GROUND_TRUE_DEGREES"),
    OVERALL_TOTAL_SCORED_RACE_COUNT(0, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, "TOTAL_SCORED_RACE_COUNT"),
    EXPEDITION_RACE_AWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_AWS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TWS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TWD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TARG_TWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_BOAT_SPEED(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TARG_BOAT_SPEED(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_SOG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_COG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.LINEAR, new String[0]),
    EXPEDITION_RACE_FORESTAY_LOAD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_RAKE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_COURSE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_HEADING(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_VMG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_VMG_TARG_VMG_DELTA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_RATE_OF_TURN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_RUDDER_ANGLE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TARGET_HEEL(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_PORT_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_STB_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_DIST_TO_PORT_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_DIST_TO_STB_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_GUN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_BURN_TO_LINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_BURN_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_TIME_TO_BURN_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_DISTANCE_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_DISTANCE_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_DISTANCE_BELOW_LINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_LINE_SQUARE_FOR_WIND_DIRECTION(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_AWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_AWS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TWS(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TWD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TARG_TWA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_BOAT_SPEED(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TARG_BOAT_SPEED(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_SOG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_COG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.LINEAR, new String[0]),
    EXPEDITION_LEG_FORESTAY_LOAD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_RAKE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_COURSE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_HEADING(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_VMG(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_VMG_TARG_VMG_DELTA(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_RATE_OF_TURN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_RUDDER_ANGLE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TARGET_HEEL(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_PORT_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_STB_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_DIST_TO_PORT_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_DIST_TO_STB_LAYLINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_GUN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_BURN_TO_LINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_TIME_TO_BURN_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_DISTANCE_TO_PIN(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_DISTANCE_BELOW_LINE(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_BARO(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_LOAD_S(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_LOAD_P(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_JIB_CAR_PORT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_JIB_CAR_STBD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_MAST_BUTT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_BARO(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_LOAD_S(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_LOAD_P(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_JIB_CAR_PORT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_JIB_CAR_STBD(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_LEG_MAST_BUTT(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    BRAVO_RACE_HEEL_IN_DEGREES(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    BRAVO_RACE_PITCH_IN_DEGREES(2, SortingOrder.DESCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    PERCENT_TARGET_BOAT_SPEED(2, SortingOrder.DESCENDING, SecuredDomainType.LeaderboardActions.PREMIUM_LEADERBOARD_INFORMATION, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]),
    EXPEDITION_RACE_KICKER_TENSION(2, SortingOrder.ASCENDING, null, ColorMapper.ValueSpreader.CUBIC_ROOT, new String[0]);

    private int precision;
    private SortingOrder defaultSortingOrder;
    private HasPermissions.Action premiumAction;
    private final String[] oldNames;
    private final ColorMapper.ValueSpreader valueSpreader;

    private DetailType(int precision, SortingOrder defaultSortingOrder, HasPermissions.Action premiumAction, ColorMapper.ValueSpreader valueSpreader, String ... oldNames) {
        this.oldNames = oldNames;
        this.precision = precision;
        this.premiumAction = premiumAction;
        this.defaultSortingOrder = defaultSortingOrder;
        this.valueSpreader = valueSpreader;
    }

    public int getPrecision() {
        return this.precision;
    }

    public ColorMapper.ValueSpreader getValueSpreader() {
        return this.valueSpreader;
    }

    public SortingOrder getDefaultSortingOrder() {
        return this.defaultSortingOrder;
    }

    public HasPermissions.Action getPremiumAction() {
        return this.premiumAction;
    }

    public boolean isExpeditionType() {
        return DetailType.getLegExpeditionDetailColumnTypes().contains(this) || DetailType.getRaceExpeditionDetailTypes().contains(this);
    }

    public boolean isDegreeTypeWithRecalculation() {
        return this == CHART_COURSE_OVER_GROUND_TRUE_DEGREES;
    }

    public static Collection<DetailType> getAutoplayDetailTypesForChart() {
        LinkedHashSet<DetailType> availableDetailsTypes = new LinkedHashSet<DetailType>();
        availableDetailsTypes.add(LEG_TACKTYPE_LONGTACK_SHORTTACK);
        availableDetailsTypes.add(CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD);
        availableDetailsTypes.add(CHART_WINDWARD_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_CHANGE);
        availableDetailsTypes.add(LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS);
        availableDetailsTypes.add(LEG_DISTANCE_TRAVELED);
        availableDetailsTypes.add(LEG_VELOCITY_MADE_GOOD_IN_KNOTS);
        availableDetailsTypes.add(LEG_GAP_TO_LEADER_IN_SECONDS);
        availableDetailsTypes.add(LEG_GAP_TO_LEADER_IN_SECONDS_CHANGE);
        availableDetailsTypes.add(RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS);
        availableDetailsTypes.add(RACE_RANK);
        availableDetailsTypes.add(REGATTA_RANK);
        availableDetailsTypes.add(CHART_DISTANCE_TO_START_LINE);
        availableDetailsTypes.add(CHART_BEAT_ANGLE);
        availableDetailsTypes.add(CHART_ABS_TWA);
        availableDetailsTypes.add(CHART_COURSE_OVER_GROUND_TRUE_DEGREES);
        availableDetailsTypes.add(BRAVO_RACE_CURRENT_RIDE_HEIGHT_IN_METERS);
        availableDetailsTypes.add(BRAVO_RACE_HEEL_IN_DEGREES);
        availableDetailsTypes.add(BRAVO_RACE_PITCH_IN_DEGREES);
        availableDetailsTypes.add(PERCENT_TARGET_BOAT_SPEED);
        return availableDetailsTypes;
    }

    public static Collection<DetailType> getRaceExpeditionDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(EXPEDITION_RACE_AWA);
        allowed.add(EXPEDITION_RACE_AWS);
        allowed.add(EXPEDITION_RACE_TWA);
        allowed.add(EXPEDITION_RACE_TWS);
        allowed.add(EXPEDITION_RACE_TWD);
        allowed.add(EXPEDITION_RACE_TARG_TWA);
        allowed.add(EXPEDITION_RACE_BOAT_SPEED);
        allowed.add(EXPEDITION_RACE_TARG_BOAT_SPEED);
        allowed.add(EXPEDITION_RACE_SOG);
        allowed.add(EXPEDITION_RACE_COG);
        allowed.add(EXPEDITION_RACE_FORESTAY_LOAD);
        allowed.add(EXPEDITION_RACE_RAKE);
        allowed.add(EXPEDITION_RACE_COURSE);
        allowed.add(EXPEDITION_RACE_HEADING);
        allowed.add(EXPEDITION_RACE_VMG);
        allowed.add(EXPEDITION_RACE_VMG_TARG_VMG_DELTA);
        allowed.add(EXPEDITION_RACE_RATE_OF_TURN);
        allowed.add(EXPEDITION_RACE_RUDDER_ANGLE);
        allowed.add(EXPEDITION_RACE_TARGET_HEEL);
        allowed.add(EXPEDITION_RACE_TIME_TO_PORT_LAYLINE);
        allowed.add(EXPEDITION_RACE_TIME_TO_STB_LAYLINE);
        allowed.add(EXPEDITION_RACE_DIST_TO_PORT_LAYLINE);
        allowed.add(EXPEDITION_RACE_DIST_TO_STB_LAYLINE);
        allowed.add(EXPEDITION_RACE_TIME_TO_GUN);
        allowed.add(EXPEDITION_RACE_TIME_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_RACE_TIME_TO_PIN);
        allowed.add(EXPEDITION_RACE_TIME_TO_BURN_TO_LINE);
        allowed.add(EXPEDITION_RACE_TIME_TO_BURN_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_RACE_TIME_TO_BURN_TO_PIN);
        allowed.add(EXPEDITION_RACE_DISTANCE_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_RACE_DISTANCE_TO_PIN);
        allowed.add(EXPEDITION_RACE_DISTANCE_BELOW_LINE);
        allowed.add(EXPEDITION_RACE_LINE_SQUARE_FOR_WIND_DIRECTION);
        allowed.add(EXPEDITION_RACE_BARO);
        allowed.add(EXPEDITION_RACE_LOAD_S);
        allowed.add(EXPEDITION_RACE_LOAD_P);
        allowed.add(EXPEDITION_RACE_JIB_CAR_PORT);
        allowed.add(EXPEDITION_RACE_JIB_CAR_STBD);
        allowed.add(EXPEDITION_RACE_MAST_BUTT);
        allowed.add(EXPEDITION_RACE_KICKER_TENSION);
        return allowed;
    }

    public static Collection<DetailType> getRaceExtendedBravoDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_PORT_DAGGERBOARD_RAKE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_STBD_DAGGERBOARD_RAKE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_PORT_RUDDER_RAKE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_STBD_RUDDER_RAKE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_MAST_ROTATION_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_LEEWAY_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_SET);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_DRIFT_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_DEPTH_IN_METERS);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_RUDDER_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_TACK_ANGLE_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_PERCENTAGE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_DEFLECTOR_IN_MILLIMETERS);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_RAKE_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_TARGET_HEEL_ANGLE_IN_DEGREES);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_FORESTAY_LOAD);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_FORESTAY_PRESSURE);
        allowed.add(BRAVOEXTENDED_RACE_CURRENT_TARGET_BOATSPEED_PERCENTAGE);
        return allowed;
    }

    public static Collection<DetailType> getRaceBravoDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(BRAVO_RACE_HEEL_IN_DEGREES);
        allowed.add(BRAVO_RACE_PITCH_IN_DEGREES);
        allowed.add(BRAVO_RACE_CURRENT_RIDE_HEIGHT_IN_METERS);
        allowed.add(RACE_CURRENT_DISTANCE_FOILED_IN_METERS);
        allowed.add(RACE_CURRENT_DURATION_FOILED_IN_SECONDS);
        return allowed;
    }

    public static Collection<DetailType> getLegBravoDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(BRAVO_LEG_CURRENT_HEEL_IN_DEGREES);
        allowed.add(BRAVO_LEG_CURRENT_PITCH_IN_DEGREES);
        allowed.add(BRAVO_LEG_CURRENT_RIDE_HEIGHT_IN_METERS);
        allowed.add(BRAVOEXTENDED_LEG_CURRENT_DISTANCE_FOILED_IN_METERS);
        allowed.add(BRAVOEXTENDED_LEG_CURRENT_DURATION_FOILED_IN_SECONDS);
        return allowed;
    }

    public static Collection<DetailType> getAllRaceDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(RACE_GAP_TO_LEADER_IN_SECONDS);
        allowed.add(PERCENT_TARGET_BOAT_SPEED);
        allowed.add(RACE_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS);
        allowed.add(RACE_DISTANCE_TRAVELED);
        allowed.add(RACE_DISTANCE_TRAVELED_INCLUDING_GATE_START);
        allowed.add(RACE_TIME_TRAVELED);
        allowed.add(RACE_CALCULATED_TIME_TRAVELED);
        allowed.add(RACE_IMPLIED_WIND);
        allowed.add(RACE_CALCULATED_TIME_AT_ESTIMATED_ARRIVAL_AT_COMPETITOR_FARTHEST_AHEAD);
        allowed.add(RACE_CURRENT_SPEED_OVER_GROUND_IN_KNOTS);
        allowed.add(RACE_CURRENT_COURSE_OVER_GROUND_IN_TRUE_DEGREES);
        allowed.add(RACE_CURRENT_DISTANCE_FOILED_IN_METERS);
        allowed.add(RACE_CURRENT_DURATION_FOILED_IN_SECONDS);
        allowed.add(RACE_DISTANCE_TO_COMPETITOR_FARTHEST_AHEAD_IN_METERS);
        allowed.add(NUMBER_OF_MANEUVERS);
        allowed.add(RACE_DISPLAY_LEGS);
        allowed.add(RACE_DISPLAY_BOATS);
        allowed.add(RACE_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS);
        allowed.add(RACE_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS);
        allowed.add(RACE_RATIO_BETWEEN_TIME_SINCE_LAST_POSITION_FIX_AND_AVERAGE_SAMPLING_INTERVAL);
        allowed.add(RACE_CURRENT_LEG);
        allowed.addAll(DetailType.getRaceBravoDetailTypes());
        allowed.addAll(DetailType.getRaceExtendedBravoDetailTypes());
        allowed.addAll(DetailType.getRaceExpeditionDetailTypes());
        return allowed;
    }

    public static Collection<DetailType> getAllNonRestrictedDetailTypes() {
        LinkedHashSet<DetailType> all = new LinkedHashSet<DetailType>(Arrays.asList(DetailType.values()));
        all.removeAll(DetailType.getRaceBravoDetailTypes());
        all.removeAll(DetailType.getLegBravoDetailTypes());
        all.removeAll(DetailType.getRaceExtendedBravoDetailTypes());
        all.removeAll(DetailType.getRaceExpeditionDetailTypes());
        all.removeAll(DetailType.getLegExpeditionDetailColumnTypes());
        all.removeAll(DetailType.getOverallBravoDetailTypes());
        all.removeAll(DetailType.getAllToTToDHandicapDetailTypes());
        all.removeAll(DetailType.getAllOrcPerformanceCurveDetailTypes());
        return all;
    }

    public static Collection<DetailType> getAvailableOverallDetailColumnTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(REGATTA_RANK);
        allowed.add(OVERALL_TOTAL_DISTANCE_TRAVELED);
        allowed.add(OVERALL_TOTAL_AVERAGE_SPEED_OVER_GROUND);
        allowed.add(OVERALL_TOTAL_TIME_SAILED_IN_SECONDS);
        allowed.add(OVERALL_MAXIMUM_SPEED_OVER_GROUND_IN_KNOTS);
        allowed.add(OVERALL_TIME_ON_TIME_FACTOR);
        allowed.add(OVERALL_TIME_ON_DISTANCE_ALLOWANCE_IN_SECONDS_PER_NAUTICAL_MILE);
        allowed.add(OVERALL_TOTAL_SCORED_RACE_COUNT);
        return allowed;
    }

    public static Collection<DetailType> getOverallBravoDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(OVERALL_TOTAL_DISTANCE_FOILED_IN_METERS);
        allowed.add(OVERALL_TOTAL_DURATION_FOILED_IN_SECONDS);
        return allowed;
    }

    public static Collection<? extends DetailType> getAllToTToDHandicapDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(RACE_CALCULATED_TIME_AT_ESTIMATED_ARRIVAL_AT_COMPETITOR_FARTHEST_AHEAD);
        allowed.add(RACE_CALCULATED_TIME_TRAVELED);
        return allowed;
    }

    public static Collection<? extends DetailType> getAllOrcPerformanceCurveDetailTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(RACE_CALCULATED_TIME_AT_ESTIMATED_ARRIVAL_AT_COMPETITOR_FARTHEST_AHEAD);
        allowed.add(RACE_CALCULATED_TIME_TRAVELED);
        allowed.add(RACE_IMPLIED_WIND);
        return allowed;
    }

    public static Collection<DetailType> getLegDetailColumnTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(LEG_AVERAGE_SPEED_OVER_GROUND_IN_KNOTS);
        allowed.add(LEG_DISTANCE_TRAVELED);
        allowed.add(LEG_DISTANCE_TRAVELED_INCLUDING_GATE_START);
        allowed.add(LEG_GAP_TO_LEADER_IN_SECONDS);
        allowed.add(LEG_GAP_CHANGE_SINCE_LEG_START_IN_SECONDS);
        allowed.add(LEG_SIDE_TO_WHICH_MARK_AT_LEG_START_WAS_ROUNDED);
        allowed.add(LEG_CURRENT_SPEED_OVER_GROUND_IN_KNOTS);
        allowed.add(LEG_WINDWARD_DISTANCE_TO_GO_IN_METERS);
        allowed.add(NUMBER_OF_MANEUVERS);
        allowed.add(LEG_ESTIMATED_TIME_TO_NEXT_WAYPOINT_IN_SECONDS);
        allowed.add(LEG_VELOCITY_MADE_GOOD_IN_KNOTS);
        allowed.add(LEG_TIME_TRAVELED);
        allowed.add(LEG_CORRECTED_TIME_TRAVELED);
        allowed.add(LEG_AVERAGE_ABSOLUTE_CROSS_TRACK_ERROR_IN_METERS);
        allowed.add(LEG_AVERAGE_SIGNED_CROSS_TRACK_ERROR_IN_METERS);
        allowed.add(LEG_RANK_GAIN);
        return allowed;
    }

    public static Collection<DetailType> getRaceStartAnalysisColumnTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(RACE_DISTANCE_TO_START_FIVE_SECONDS_BEFORE_RACE_START);
        allowed.add(RACE_SPEED_OVER_GROUND_FIVE_SECONDS_BEFORE_START);
        allowed.add(DISTANCE_TO_START_AT_RACE_START);
        allowed.add(TIME_BETWEEN_RACE_START_AND_COMPETITOR_START);
        allowed.add(SPEED_OVER_GROUND_AT_RACE_START);
        allowed.add(SPEED_OVER_GROUND_WHEN_PASSING_START);
        allowed.add(DISTANCE_TO_STARBOARD_END_OF_STARTLINE_WHEN_PASSING_START_IN_METERS);
        allowed.add(START_TACK);
        return allowed;
    }

    public static Collection<DetailType> getLegExpeditionDetailColumnTypes() {
        LinkedHashSet<DetailType> allowed = new LinkedHashSet<DetailType>();
        allowed.add(EXPEDITION_LEG_AWA);
        allowed.add(EXPEDITION_LEG_AWS);
        allowed.add(EXPEDITION_LEG_TWA);
        allowed.add(EXPEDITION_LEG_TWS);
        allowed.add(EXPEDITION_LEG_TWD);
        allowed.add(EXPEDITION_LEG_TARG_TWA);
        allowed.add(EXPEDITION_LEG_BOAT_SPEED);
        allowed.add(EXPEDITION_LEG_TARG_BOAT_SPEED);
        allowed.add(EXPEDITION_LEG_SOG);
        allowed.add(EXPEDITION_LEG_COG);
        allowed.add(EXPEDITION_LEG_FORESTAY_LOAD);
        allowed.add(EXPEDITION_LEG_RAKE);
        allowed.add(EXPEDITION_LEG_COURSE);
        allowed.add(EXPEDITION_LEG_HEADING);
        allowed.add(EXPEDITION_LEG_VMG);
        allowed.add(EXPEDITION_LEG_VMG_TARG_VMG_DELTA);
        allowed.add(EXPEDITION_LEG_RATE_OF_TURN);
        allowed.add(EXPEDITION_LEG_RUDDER_ANGLE);
        allowed.add(EXPEDITION_LEG_TARGET_HEEL);
        allowed.add(EXPEDITION_LEG_TIME_TO_PORT_LAYLINE);
        allowed.add(EXPEDITION_LEG_TIME_TO_STB_LAYLINE);
        allowed.add(EXPEDITION_LEG_DIST_TO_PORT_LAYLINE);
        allowed.add(EXPEDITION_LEG_DIST_TO_STB_LAYLINE);
        allowed.add(EXPEDITION_LEG_TIME_TO_GUN);
        allowed.add(EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_LEG_TIME_TO_PIN);
        allowed.add(EXPEDITION_LEG_TIME_TO_BURN_TO_LINE);
        allowed.add(EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_LEG_TIME_TO_BURN_TO_PIN);
        allowed.add(EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT);
        allowed.add(EXPEDITION_LEG_DISTANCE_TO_PIN);
        allowed.add(EXPEDITION_LEG_DISTANCE_BELOW_LINE);
        allowed.add(EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION);
        allowed.add(EXPEDITION_LEG_BARO);
        allowed.add(EXPEDITION_LEG_LOAD_S);
        allowed.add(EXPEDITION_LEG_LOAD_P);
        allowed.add(EXPEDITION_LEG_JIB_CAR_PORT);
        allowed.add(EXPEDITION_LEG_JIB_CAR_STBD);
        allowed.add(EXPEDITION_LEG_MAST_BUTT);
        return allowed;
    }

    public static Collection<DetailType> getDisabledDetailColumTypes() {
        LinkedHashSet<DetailType> disabled = new LinkedHashSet<DetailType>();
        disabled.add(EXPEDITION_LEG_TARG_TWA);
        disabled.add(EXPEDITION_LEG_VMG);
        disabled.add(EXPEDITION_LEG_VMG_TARG_VMG_DELTA);
        disabled.add(EXPEDITION_LEG_RATE_OF_TURN);
        disabled.add(EXPEDITION_LEG_RUDDER_ANGLE);
        disabled.add(EXPEDITION_LEG_TIME_TO_PORT_LAYLINE);
        disabled.add(EXPEDITION_LEG_TIME_TO_STB_LAYLINE);
        disabled.add(EXPEDITION_LEG_DIST_TO_PORT_LAYLINE);
        disabled.add(EXPEDITION_LEG_DIST_TO_STB_LAYLINE);
        disabled.add(EXPEDITION_LEG_TIME_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_LEG_TIME_TO_PIN);
        disabled.add(EXPEDITION_LEG_TIME_TO_BURN_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_LEG_TIME_TO_BURN_TO_PIN);
        disabled.add(EXPEDITION_LEG_DISTANCE_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_LEG_DISTANCE_TO_PIN);
        disabled.add(EXPEDITION_LEG_LINE_SQUARE_FOR_WIND_DIRECTION);
        disabled.add(EXPEDITION_RACE_TARG_TWA);
        disabled.add(EXPEDITION_RACE_VMG);
        disabled.add(EXPEDITION_RACE_VMG_TARG_VMG_DELTA);
        disabled.add(EXPEDITION_RACE_RUDDER_ANGLE);
        disabled.add(EXPEDITION_RACE_TIME_TO_PORT_LAYLINE);
        disabled.add(EXPEDITION_RACE_TIME_TO_STB_LAYLINE);
        disabled.add(EXPEDITION_RACE_DIST_TO_PORT_LAYLINE);
        disabled.add(EXPEDITION_RACE_DIST_TO_STB_LAYLINE);
        disabled.add(EXPEDITION_RACE_TIME_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_RACE_TIME_TO_PIN);
        disabled.add(EXPEDITION_RACE_TIME_TO_BURN_TO_PIN);
        disabled.add(EXPEDITION_RACE_TIME_TO_BURN_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_RACE_DISTANCE_TO_COMMITTEE_BOAT);
        disabled.add(EXPEDITION_RACE_DISTANCE_TO_PIN);
        disabled.add(EXPEDITION_RACE_LINE_SQUARE_FOR_WIND_DIRECTION);
        return disabled;
    }

    public static Collection<DetailType> getAllLegDetailColumnTypes() {
        LinkedHashSet<DetailType> all = new LinkedHashSet<DetailType>();
        all.addAll(DetailType.getLegDetailColumnTypes());
        all.addAll(DetailType.getLegBravoDetailTypes());
        all.addAll(DetailType.getLegExpeditionDetailColumnTypes());
        return all;
    }

    /*
     * Unable to fully structure code
     */
    public static DetailType valueOfString(String value) {
        try {
            return DetailType.valueOf(value);
        }
        catch (IllegalArgumentException e) {
            var5_2 = DetailType.values();
            var4_3 = var5_2.length;
            var3_4 = 0;
            ** while (var3_4 < var4_3)
        }
lbl-1000:
        // 1 sources

        {
            t = var5_2[var3_4];
            if (t.oldNames != null) {
                var9_9 = t.oldNames;
                var8_8 = t.oldNames.length;
                var7_7 = 0;
                while (var7_7 < var8_8) {
                    oldname = var9_9[var7_7];
                    if (oldname.equals(value)) {
                        return t;
                    }
                    ++var7_7;
                }
            }
            ++var3_4;
            continue;
        }
lbl21:
        // 1 sources

        throw new IllegalArgumentException("Could not restore " + value + " to an DetailType enum");
    }

    public static Set<HasPermissions.Action> getAllPremiumActionsFromAll() {
        HashSet<HasPermissions.Action> premiumLeaderboardActions = new HashSet<HasPermissions.Action>();
        DetailType[] detailTypeArray = DetailType.values();
        int n = detailTypeArray.length;
        int n2 = 0;
        while (n2 < n) {
            DetailType detailType = detailTypeArray[n2];
            premiumLeaderboardActions.add(detailType.getPremiumAction());
            ++n2;
        }
        return premiumLeaderboardActions;
    }

    public static Set<HasPermissions.Action> getAllPremiumActionsFromSubset(Iterable<DetailType> detailTypes) {
        HashSet<HasPermissions.Action> premiumLeaderboardActions = new HashSet<HasPermissions.Action>();
        for (DetailType detailType : detailTypes) {
            if (detailType.getPremiumAction() == null) continue;
            premiumLeaderboardActions.add(detailType.getPremiumAction());
        }
        return premiumLeaderboardActions;
    }
}

