/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.kmeans;

import com.sap.sse.common.scalablevalue.ScalableValueWithDistance;
import com.sap.sse.util.kmeans.Cluster;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class KMeansMappingClusterer<E, ValueType, AveragesTo, T extends ScalableValueWithDistance<ValueType, AveragesTo>> {
    private List<Cluster<E, ValueType, AveragesTo, T>> clusters;
    private final Function<E, T> mapper;
    private int numberOfIterations;

    public KMeansMappingClusterer(int numberOfClusters, Iterable<E> elements, Function<E, T> mapper) {
        this(numberOfClusters, elements, mapper, KMeansMappingClusterer.randomizedSeeds(numberOfClusters, elements, mapper));
    }

    public KMeansMappingClusterer(int numberOfClusters, Stream<E> elements, Function<E, T> mapper) {
        this(numberOfClusters, KMeansMappingClusterer.streamToList(elements), mapper);
    }

    private static <E> Iterable<E> streamToList(Stream<E> elements) {
        assert (!elements.isParallel());
        return elements.collect(Collectors.toList());
    }

    private static <E, ValueType, AveragesTo, T extends ScalableValueWithDistance<ValueType, AveragesTo>> Iterator<AveragesTo> randomizedSeeds(int numberOfClusters, Iterable<E> elements, Function<E, T> mapper) {
        ArrayList clusters = new ArrayList(numberOfClusters);
        Random random = new Random();
        int i = 0;
        for (E e : elements) {
            if (i < numberOfClusters) {
                Cluster cluster = new Cluster(null, mapper);
                clusters.add(cluster);
                cluster.add(e);
            } else {
                ((Cluster)clusters.get(random.nextInt(numberOfClusters))).add(e);
            }
            ++i;
        }
        return clusters.stream().map(c -> c.getCentroid()).iterator();
    }

    public KMeansMappingClusterer(int numberOfClusters, Stream<E> elements, Function<E, T> mapper, Stream<? extends AveragesTo> seeds) {
        this(numberOfClusters, KMeansMappingClusterer.streamToList(elements), mapper, seeds.iterator());
    }

    public KMeansMappingClusterer(int numberOfClusters, Iterable<E> elements, Function<E, T> mapper, Iterator<? extends AveragesTo> seeds) {
        this.mapper = mapper;
        this.clusters = new ArrayList<Cluster<E, ValueType, AveragesTo, T>>();
        this.initClusters(elements, seeds);
        if (!this.clusters.isEmpty()) {
            this.addElementsToNearestCluster(elements);
            this.iterate(elements);
        }
    }

    private void initClusters(Iterable<E> elements, Iterator<? extends AveragesTo> seeds) {
        Iterator<E> elementsIter = elements.iterator();
        while (elementsIter.hasNext() && seeds.hasNext()) {
            elementsIter.next();
            this.clusters.add(new Cluster(seeds.next(), this.mapper));
        }
    }

    private void iterate(Iterable<E> elements) {
        List<Cluster<E, ValueType, AveragesTo, T>> oldClusters;
        do {
            ++this.numberOfIterations;
            ArrayList newClusters = new ArrayList(this.clusters.size());
            for (Cluster<E, ValueType, AveragesTo, T> c : this.clusters) {
                AveragesTo newMean = c.getCentroid();
                if (newMean == null) {
                    newMean = c.getMean();
                }
                newClusters.add(new Cluster(newMean, this.mapper));
            }
            oldClusters = this.clusters;
            this.clusters = newClusters;
            this.addElementsToNearestCluster(elements);
        } while (!this.clusters.equals(oldClusters));
    }

    public int getNumberOfIterations() {
        return this.numberOfIterations;
    }

    private void addElementsToNearestCluster(Iterable<E> elements) {
        assert (!this.clusters.isEmpty());
        for (E e : elements) {
            Iterator<Cluster<E, ValueType, AveragesTo, T>> clusterIter = this.clusters.iterator();
            Cluster<E, ValueType, AveragesTo, T> nearestCluster = clusterIter.next();
            double leastDistance = nearestCluster.getDistanceFromMean(e);
            while (clusterIter.hasNext()) {
                Cluster<E, ValueType, AveragesTo, T> nextCluster = clusterIter.next();
                double distance = nextCluster.getDistanceFromMean(e);
                if (!(distance < leastDistance)) continue;
                leastDistance = distance;
                nearestCluster = nextCluster;
            }
            nearestCluster.add(e);
        }
    }

    public Set<Cluster<E, ValueType, AveragesTo, T>> getClusters() {
        LinkedHashSet<Cluster<Cluster<E, ValueType, AveragesTo, T>, ValueType, AveragesTo, T>> result = new LinkedHashSet<Cluster<Cluster<E, ValueType, AveragesTo, T>, ValueType, AveragesTo, T>>();
        for (Cluster<E, ValueType, AveragesTo, T> i : this.clusters) {
            if (i.isEmpty()) continue;
            result.add(i);
        }
        return result;
    }
}

