/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import com.sap.sse.util.impl.KnowsExecutor;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGet;
import com.sap.sse.util.impl.KnowsExecutorAndTracingGetImpl;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.RunnableScheduledFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;

public class ThreadPoolAwareRunnableScheduledFutureDelegate<V>
extends KnowsExecutorAndTracingGetImpl<V>
implements KnowsExecutorAndTracingGet<V>,
RunnableScheduledFuture<V> {
    private final RunnableScheduledFuture<V> future;

    public ThreadPoolAwareRunnableScheduledFutureDelegate(ThreadPoolExecutor executor, RunnableScheduledFuture<V> future) {
        this.future = future;
        this.setExecutorThisTaskIsScheduledFor(executor);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return this.future.getDelay(unit);
    }

    @Override
    public void run() {
        this.future.run();
    }

    @Override
    public boolean isPeriodic() {
        return this.future.isPeriodic();
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        return this.future.cancel(mayInterruptIfRunning);
    }

    @Override
    public int compareTo(Delayed o) {
        int result = o instanceof ThreadPoolAwareRunnableScheduledFutureDelegate ? this.future.compareTo(((ThreadPoolAwareRunnableScheduledFutureDelegate)o).future) : this.future.compareTo(o);
        return result;
    }

    @Override
    public boolean isCancelled() {
        return this.future.isCancelled();
    }

    @Override
    public boolean isDone() {
        return this.future.isDone();
    }

    @Override
    public V get() throws InterruptedException, ExecutionException {
        return this.callGetAndTraceAfterEachTimeout(this.future);
    }

    @Override
    public V get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.future.get(timeout, unit);
    }

    @Override
    public void setExecutorThisTaskIsScheduledFor(ThreadPoolExecutor executorThisTaskIsScheduledFor) {
        if (this.future instanceof KnowsExecutor) {
            ((KnowsExecutor)((Object)this.future)).setExecutorThisTaskIsScheduledFor(executorThisTaskIsScheduledFor);
        }
        super.setExecutorThisTaskIsScheduledFor(executorThisTaskIsScheduledFor);
    }
}

