/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.impl;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.logging.Level;
import java.util.logging.Logger;

public class CountingOutputStream
extends FilterOutputStream {
    private static final Logger logger = Logger.getLogger(CountingOutputStream.class.getName());
    private long count;
    private final long logEveryHowManyBytes;
    private long lastMultiple;
    private final Level level;
    private final String name;

    public CountingOutputStream(OutputStream out, long logEveryHowManyBytes, Level logLevel, String name) {
        super(out);
        this.level = logLevel;
        this.name = name;
        this.logEveryHowManyBytes = logEveryHowManyBytes;
    }

    @Override
    public void write(int b) throws IOException {
        super.write(b);
        this.count(1);
    }

    private void count(int bytesWritten) {
        this.count += (long)bytesWritten;
        if (this.count >= (this.lastMultiple + 1L) * this.logEveryHowManyBytes) {
            ++this.lastMultiple;
            this.log();
        }
    }

    private void log() {
        logger.log(this.level, "wrote " + this.count + " bytes " + (this.count > 0x100000L ? "(" + this.count / 1024L / 1024L + "MB) " : "") + "to " + this.name);
    }

    @Override
    public void write(byte[] b) throws IOException {
        super.write(b);
        this.count(b.length);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        super.write(b, off, len);
        this.count(len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        this.log();
    }
}

