/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.graph.impl;

import com.sap.sse.common.Util;
import com.sap.sse.util.graph.DirectedEdge;
import com.sap.sse.util.graph.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;

public class PathImpl<T>
implements Path<T> {
    private Set<T> nodesForFastContains;
    private final List<T> nodesInOrder;

    public PathImpl(Iterable<T> nodes) {
        this.nodesInOrder = new ArrayList<T>(Util.size(nodes));
        Util.addAll(nodes, this.nodesInOrder);
    }

    @Override
    public Iterable<T> getNodes() {
        return Collections.unmodifiableCollection(this.nodesInOrder);
    }

    @Override
    public Path<T> extend(T tail) {
        ArrayList<T> newNodes = new ArrayList<T>(this.nodesInOrder);
        newNodes.add(tail);
        return new PathImpl<T>(newNodes);
    }

    @Override
    public Path<T> extend(Path<T> subPath) {
        ArrayList<T> newNodes = new ArrayList<T>(this.nodesInOrder);
        Util.addAll(subPath, newNodes);
        return new PathImpl<T>(newNodes);
    }

    @Override
    public Path<T> tail() {
        return new PathImpl<T>(this.nodesInOrder.subList(1, this.nodesInOrder.size()));
    }

    @Override
    public Path<T> subPath(T start) {
        ArrayList<T> newNodes = new ArrayList<T>();
        boolean found = false;
        for (T node : this.nodesInOrder) {
            boolean bl = found = found || node.equals(start);
            if (!found) continue;
            newNodes.add(node);
        }
        return new PathImpl(newNodes);
    }

    @Override
    public Path<T> subPath(T start, T endExclusive) {
        ArrayList<T> newNodes = new ArrayList<T>();
        boolean found = false;
        for (T node : this.nodesInOrder) {
            boolean bl = found = (found || node.equals(start)) && !node.equals(endExclusive);
            if (!found) continue;
            newNodes.add(node);
        }
        return new PathImpl(newNodes);
    }

    @Override
    public boolean contains(T node) {
        if (this.nodesForFastContains == null) {
            HashSet<T> nffc = new HashSet<T>(this.nodesInOrder);
            this.nodesForFastContains = nffc;
        }
        return this.nodesForFastContains.contains(node);
    }

    @Override
    public boolean contains(DirectedEdge<T> edge) {
        int indexOfFrom;
        return this.contains(edge.getFrom()) && (indexOfFrom = this.nodesInOrder.indexOf(edge.getFrom())) != this.nodesInOrder.size() - 1 && this.nodesInOrder.get(indexOfFrom + 1).equals(edge.getTo());
    }

    @Override
    public T head() {
        return this.nodesInOrder.isEmpty() ? null : (T)this.nodesInOrder.get(0);
    }

    @Override
    public T last() {
        return this.nodesInOrder.isEmpty() ? null : (T)this.nodesInOrder.get(this.nodesInOrder.size() - 1);
    }

    @Override
    public boolean isEmpty() {
        return this.nodesInOrder.isEmpty();
    }

    @Override
    public Iterator<T> iterator() {
        return this.nodesInOrder.iterator();
    }

    @Override
    public boolean intersects(Path<T> other) {
        return StreamSupport.stream(other.spliterator(), false).anyMatch(n -> this.contains(n));
    }

    public String toString() {
        return "(" + this.nodesInOrder.stream().map(n -> n.toString()).collect(Collectors.joining(" -> ")) + ")";
    }
}

