/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.graph.impl;

import com.sap.sse.common.Util;
import com.sap.sse.util.graph.CycleCluster;
import com.sap.sse.util.graph.CycleClusters;
import com.sap.sse.util.graph.DirectedEdge;
import com.sap.sse.util.graph.DirectedGraph;
import com.sap.sse.util.graph.impl.CycleClusterImpl;
import com.sap.sse.util.graph.impl.CycleClustersImpl;
import com.sap.sse.util.graph.impl.DirectedEdgeImpl;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;

public class DirectedGraphImpl<T>
implements DirectedGraph<T> {
    private final Set<T> nodes;
    private final Set<DirectedEdge<T>> edges;
    private final Map<T, Set<T>> immediateSuccessors;
    private final Set<T> roots;
    private final CycleClusters<T> cycleClusters;

    public DirectedGraphImpl(Set<T> nodes, Set<DirectedEdge<T>> edges) {
        this.nodes = nodes;
        this.edges = edges;
        HashMap succ = new HashMap();
        HashMap pred = new HashMap();
        for (T t : nodes) {
            succ.put(t, new HashSet());
            pred.put(t, new HashSet());
        }
        for (DirectedEdge directedEdge : edges) {
            ((Set)succ.get(directedEdge.getFrom())).add(directedEdge.getTo());
            ((Set)pred.get(directedEdge.getTo())).add(directedEdge.getFrom());
        }
        HashMap hashMap = new HashMap();
        HashMap predWithUnmodifiableSets = new HashMap();
        HashSet<T> modifiableRoots = new HashSet<T>();
        for (T node : nodes) {
            hashMap.put(node, Collections.unmodifiableSet((Set)succ.get(node)));
            Set preds = (Set)pred.get(node);
            predWithUnmodifiableSets.put(node, Collections.unmodifiableSet(preds));
            if (!preds.isEmpty()) continue;
            modifiableRoots.add(node);
        }
        this.immediateSuccessors = Collections.unmodifiableMap(hashMap);
        this.roots = Collections.unmodifiableSet(modifiableRoots);
        this.cycleClusters = this.findStronglyConnectedComponents();
        assert (this.cycleClusters.areDisjoint());
    }

    private CycleClusters<T> findStronglyConnectedComponents() {
        HashSet<T> remainingRoots = new HashSet<T>(this.nodes);
        LinkedList worklist = new LinkedList();
        LinkedList oReps = new LinkedList();
        LinkedList oNodes = new LinkedList();
        HashSet oNodesForFastContains = new HashSet();
        int nodeCounter = 0;
        HashMap representativesForNodes = new HashMap();
        HashMap depthFirstSearchPosition = new HashMap();
        if (!this.nodes.isEmpty()) {
            Object nextRoot = remainingRoots.iterator().next();
            remainingRoots.remove(nextRoot);
            worklist.add(new Root(nextRoot));
            while (!Util.isEmpty(worklist)) {
                DFSStep nextStep = (DFSStep)worklist.removeLast();
                nodeCounter = nextStep.applyAndReturnNextDFSNumber(oReps, oNodes, representativesForNodes, depthFirstSearchPosition, remainingRoots, worklist, nodeCounter, oNodesForFastContains);
                if (!worklist.isEmpty() || remainingRoots.isEmpty()) continue;
                Object nextRoot2 = remainingRoots.iterator().next();
                remainingRoots.remove(nextRoot2);
                worklist.add(new Root(nextRoot2));
            }
        }
        HashSet cycleClusters = new HashSet();
        HashMap cycleClusterNodes = new HashMap();
        for (Map.Entry e : representativesForNodes.entrySet()) {
            Util.addToValueSet(cycleClusterNodes, e.getValue(), e.getKey());
        }
        for (Map.Entry e : cycleClusterNodes.entrySet()) {
            if (((Set)e.getValue()).size() <= 1) continue;
            cycleClusters.add(new CycleClusterImpl(e.getKey(), (Set)e.getValue()));
        }
        return new CycleClustersImpl(cycleClusters);
    }

    @Override
    public Set<T> getNodes() {
        return this.nodes;
    }

    @Override
    public Set<DirectedEdge<T>> getEdges() {
        return this.edges;
    }

    @Override
    public Set<T> getRoots() {
        return this.roots;
    }

    @Override
    public CycleClusters<T> getCycleClusters() {
        return this.cycleClusters;
    }

    @Override
    public CycleCluster<T> getCycleCluster(T node) {
        return this.cycleClusters.getCluster(node);
    }

    @Override
    public boolean areOnSameCycleCluster(T a, T b) {
        CycleCluster<T> aCluster = this.cycleClusters.getCluster(a);
        CycleCluster<T> bCluster = this.cycleClusters.getCluster(b);
        return aCluster != null && aCluster == bCluster;
    }

    @Override
    public boolean hasPath(T from, T to) {
        HashSet<T> visited = new HashSet<T>();
        LinkedList<T> toVisit = new LinkedList<T>();
        toVisit.add(from);
        visited.add(from);
        while (!toVisit.isEmpty()) {
            Object next = toVisit.removeFirst();
            if (next.equals(to)) {
                return true;
            }
            for (T successor : this.immediateSuccessors.get(next)) {
                if (visited.contains(successor)) continue;
                toVisit.add(successor);
                visited.add(successor);
            }
        }
        return false;
    }

    @Override
    public Map<T, Integer> getLengthsOfLongestPathsFromRoot() {
        Util.Pair<DirectedGraph<T>, CycleClusters<T>> dag = this.graphWithCombinedCycleNodes();
        Map preResult = ((DirectedGraph)dag.getA()).getLengthsOfLongestPathsFromRootForDag();
        HashMap result = new HashMap(preResult);
        for (CycleCluster cycleCluster : ((CycleClusters)dag.getB()).getClusters()) {
            Integer rootDistance = (Integer)result.get(cycleCluster.getRepresentative());
            for (Object representedCycleNode : cycleCluster.getClusterNodes()) {
                result.put(representedCycleNode, rootDistance);
            }
        }
        return result;
    }

    @Override
    public Util.Pair<DirectedGraph<T>, CycleClusters<T>> graphWithCombinedCycleNodes() {
        assert (this.cycleClusters != null);
        HashSet<T> newNodes = new HashSet<T>(this.nodes);
        for (CycleCluster<T> cluster : this.cycleClusters.getClusters()) {
            newNodes.removeAll(cluster.getClusterNodes());
            newNodes.add(cluster.getRepresentative());
        }
        HashSet<DirectedEdge<T>> newEdges = new HashSet<DirectedEdge<T>>();
        for (DirectedEdge<T> edge : this.edges) {
            if (this.cycleClusters.isEdgeInCycleCluster(edge)) continue;
            newEdges.add(this.replaceCycleNodesByRepresentatives(edge, this.cycleClusters));
        }
        return new Util.Pair(new DirectedGraphImpl<T>(newNodes, newEdges), this.cycleClusters);
    }

    private DirectedEdge<T> replaceCycleNodesByRepresentatives(DirectedEdge<T> edge, CycleClusters<T> cycleClusters) {
        CycleCluster<T> toCluster;
        CycleCluster<T> fromCluster;
        boolean replaced = false;
        Object from = null;
        Object to = null;
        if (from == null && (fromCluster = cycleClusters.getCluster(edge.getFrom())) != null && !fromCluster.getRepresentative().equals(edge.getFrom())) {
            from = fromCluster.getRepresentative();
            replaced = true;
        } else {
            from = edge.getFrom();
        }
        if (to == null && (toCluster = cycleClusters.getCluster(edge.getTo())) != null && !toCluster.getRepresentative().equals(edge.getTo())) {
            to = toCluster.getRepresentative();
            replaced = true;
        } else {
            to = edge.getTo();
        }
        return replaced ? new DirectedEdgeImpl<Object>(from, to) : edge;
    }

    @Override
    public Map<T, Integer> getLengthsOfLongestPathsFromRootForDag() {
        if (!Util.isEmpty(this.cycleClusters.getClusters())) {
            throw new IllegalStateException("Can't call this method on a graph with cycles; use graphWithCombinedCycleNodes() first");
        }
        HashMap result = new HashMap();
        HashSet<Object> workingSet = new HashSet<T>(this.roots);
        int longestDistanceFromRoot = 0;
        while (!workingSet.isEmpty()) {
            HashSet nextWorkingSet = new HashSet();
            for (Object node : workingSet) {
                if (result.containsKey(node) && (Integer)result.get(node) >= longestDistanceFromRoot) continue;
                result.put(node, longestDistanceFromRoot);
                nextWorkingSet.addAll(this.immediateSuccessors.get(node));
            }
            ++longestDistanceFromRoot;
            workingSet = nextWorkingSet;
        }
        return result;
    }

    private class Backtrack
    implements DFSStep<T> {
        private final T backtrackFromNode;

        public Backtrack(T backtrackFromNode) {
            this.backtrackFromNode = backtrackFromNode;
        }

        @Override
        public int applyAndReturnNextDFSNumber(LinkedList<T> oReps, LinkedList<T> oNodes, Map<T, T> representatives, Map<T, Integer> depthFirstSearchPosition, Set<T> remainingRoots, LinkedList<DFSStep<T>> worklist, int nodeCounter, Set<T> oNodesForFastContains) {
            if (this.backtrackFromNode == oReps.getLast()) {
                Object lastNodeFromoNodes;
                oReps.removeLast();
                do {
                    lastNodeFromoNodes = oNodes.removeLast();
                    oNodesForFastContains.remove(lastNodeFromoNodes);
                    representatives.put(lastNodeFromoNodes, this.backtrackFromNode);
                } while (lastNodeFromoNodes != this.backtrackFromNode);
            }
            return nodeCounter;
        }

        public String toString() {
            return "backtrack(" + this.backtrackFromNode + ")";
        }
    }

    private class DFS
    implements DFSStep<T> {
        private final T to;

        public DFS(T to) {
            this.to = to;
        }

        @Override
        public int applyAndReturnNextDFSNumber(LinkedList<T> oReps, LinkedList<T> oNodes, Map<T, T> representatives, Map<T, Integer> depthFirstSearchPosition, Set<T> remainingRoots, LinkedList<DFSStep<T>> worklist, int nodeCounter, Set<T> oNodesForFastContains) {
            worklist.add(new Backtrack(this.to));
            for (Object successor : (Set)DirectedGraphImpl.this.immediateSuccessors.get(this.to)) {
                worklist.add(new TraverseEdge(successor));
            }
            return nodeCounter;
        }

        public String toString() {
            return "DFS(" + this.to + ")";
        }
    }

    private static interface DFSStep<T> {
        public int applyAndReturnNextDFSNumber(LinkedList<T> var1, LinkedList<T> var2, Map<T, T> var3, Map<T, Integer> var4, Set<T> var5, LinkedList<DFSStep<T>> var6, int var7, Set<T> var8);
    }

    private class Root
    implements DFSStep<T> {
        private final T rootNode;

        public Root(T rootNode) {
            this.rootNode = rootNode;
        }

        @Override
        public int applyAndReturnNextDFSNumber(LinkedList<T> oReps, LinkedList<T> oNodes, Map<T, T> representatives, Map<T, Integer> depthFirstSearchPosition, Set<T> remainingRoots, LinkedList<DFSStep<T>> worklist, int nodeCounter, Set<T> oNodesForFastContains) {
            remainingRoots.remove(this.rootNode);
            depthFirstSearchPosition.put(this.rootNode, nodeCounter++);
            oReps.add(this.rootNode);
            oNodes.add(this.rootNode);
            oNodesForFastContains.add(this.rootNode);
            worklist.add(new DFS(this.rootNode));
            return nodeCounter;
        }

        public String toString() {
            return "root(" + this.rootNode + ")";
        }
    }

    private class TraverseEdge
    implements DFSStep<T> {
        private final T toNode;

        public TraverseEdge(T toNode) {
            this.toNode = toNode;
        }

        @Override
        public int applyAndReturnNextDFSNumber(LinkedList<T> oReps, LinkedList<T> oNodes, Map<T, T> representatives, Map<T, Integer> depthFirstSearchPosition, Set<T> remainingRoots, LinkedList<DFSStep<T>> worklist, int nodeCounter, Set<T> oNodesForFastContains) {
            if (depthFirstSearchPosition.containsKey(this.toNode)) {
                if (oNodesForFastContains.contains(this.toNode)) {
                    while (depthFirstSearchPosition.get(this.toNode) < depthFirstSearchPosition.get(oReps.getLast())) {
                        oReps.removeLast();
                    }
                }
            } else {
                oReps.add(this.toNode);
                oNodes.add(this.toNode);
                oNodesForFastContains.add(this.toNode);
                remainingRoots.remove(this.toNode);
                depthFirstSearchPosition.put(this.toNode, nodeCounter++);
                worklist.add(new DFS(this.toNode));
            }
            return nodeCounter;
        }
    }
}

