/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.graph;

import com.sap.sse.common.Util;
import com.sap.sse.util.graph.CycleCluster;
import com.sap.sse.util.graph.CycleClusters;
import com.sap.sse.util.graph.DirectedEdge;
import com.sap.sse.util.graph.impl.DirectedGraphImpl;
import java.util.Map;
import java.util.Set;

public interface DirectedGraph<T> {
    public static <T> DirectedGraph<T> create(Set<T> nodes, Set<DirectedEdge<T>> edges) {
        return new DirectedGraphImpl<T>(nodes, edges);
    }

    public Set<T> getNodes();

    public Set<DirectedEdge<T>> getEdges();

    public Set<T> getRoots();

    public CycleClusters<T> getCycleClusters();

    public boolean areOnSameCycleCluster(T var1, T var2);

    public boolean hasPath(T var1, T var2);

    public Map<T, Integer> getLengthsOfLongestPathsFromRoot();

    public Map<T, Integer> getLengthsOfLongestPathsFromRootForDag();

    public Util.Pair<DirectedGraph<T>, CycleClusters<T>> graphWithCombinedCycleNodes();

    public CycleCluster<T> getCycleCluster(T var1);
}

