/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util.apachelog;

import com.sap.sse.common.TimePoint;
import com.sap.sse.common.Util;
import com.sap.sse.common.impl.MillisecondsTimePoint;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Iterator;
import java.util.logging.Logger;

public class LogEntry {
    private static final Logger logger = Logger.getLogger(LogEntry.class.getName());
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("dd/MMM/yyyy:HH:mm:ss ZZZZZ");
    private final String hostname;
    private final String requestorIpString;
    private final String remoteLogname;
    private final String remoteUser;
    private final String timestampString;
    private final String request;
    private final String httpStatusCodeString;
    private final String sizeString;
    private final String referrer;
    private final String userAgent;

    public LogEntry(String logEntry) {
        Iterator i = Util.splitAlongWhitespaceRespectingDoubleQuotedPhrases((String)logEntry).iterator();
        this.hostname = ((String)i.next()).trim();
        this.requestorIpString = (String)i.next();
        this.remoteLogname = (String)i.next();
        this.remoteUser = (String)i.next();
        String dateTimeWithOpeningBracket = (String)i.next();
        String timeZoneOffsetWithClosingBracket = (String)i.next();
        this.timestampString = String.valueOf(dateTimeWithOpeningBracket.substring(1)) + " " + timeZoneOffsetWithClosingBracket.substring(0, timeZoneOffsetWithClosingBracket.length() - 1);
        this.request = (String)i.next();
        this.httpStatusCodeString = (String)i.next();
        this.sizeString = (String)i.next();
        this.referrer = (String)i.next();
        this.userAgent = (String)i.next();
    }

    public String getHostname() {
        return this.hostname;
    }

    public String getRequestorIpString() {
        return this.requestorIpString;
    }

    public InetAddress getRequestorIp() throws UnknownHostException {
        return InetAddress.getByName(this.getRequestorIpString());
    }

    public String getRemoteLogname() {
        return this.remoteLogname;
    }

    public String getRemoteUser() {
        return this.remoteUser;
    }

    public String getTimestampString() {
        return this.timestampString;
    }

    public String getDateString() {
        String result;
        int indexOfColon = this.getTimestampString().indexOf(58);
        if (indexOfColon < 0) {
            logger.warning("Couldn't find : as date separator in what was expected to be a date string: " + this.getTimestampString());
            result = null;
        } else {
            result = this.getTimestampString().substring(0, indexOfColon);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TimePoint getTimepoint() throws ParseException {
        SimpleDateFormat simpleDateFormat = this.dateFormat;
        synchronized (simpleDateFormat) {
            return new MillisecondsTimePoint(this.dateFormat.parse(this.getTimestampString()));
        }
    }

    public String getRequest() {
        return this.request;
    }

    public String getHttpStatusCodeString() {
        return this.httpStatusCodeString;
    }

    public int getHttpStatusCode() {
        return Integer.valueOf(this.getHttpStatusCodeString());
    }

    public String getSizeString() {
        return this.sizeString;
    }

    public long getSize() {
        return Long.valueOf(this.getSizeString());
    }

    public String getReferrer() {
        return this.referrer;
    }

    public String getUserAgent() {
        return this.userAgent;
    }
}

