/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.util;

import com.sap.sse.InvalidDateException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.NoSuchElementException;
import java.util.SimpleTimeZone;
import java.util.StringTokenizer;
import java.util.TimeZone;

public class DateParser {
    private static boolean check(StringTokenizer st, String token) throws InvalidDateException {
        block3: {
            try {
                if (!st.nextToken().equals(token)) break block3;
                return true;
            }
            catch (NoSuchElementException ex) {
                return false;
            }
        }
        throw new InvalidDateException("Missing [" + token + "]");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Calendar getCalendar(Calendar calendar, String isodate) throws InvalidDateException {
        StringTokenizer st = new StringTokenizer(isodate, "-T:.,+Z ", true);
        calendar.clear();
        try {
            String timeSeparator;
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            int year = Integer.parseInt(st.nextToken());
            calendar.set(1, year);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int month = Integer.parseInt(st.nextToken()) - 1;
            calendar.set(2, month);
            if (!DateParser.check(st, "-") || !st.hasMoreTokens()) {
                return calendar;
            }
            int day = Integer.parseInt(st.nextToken());
            calendar.set(5, day);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            if (!st.hasMoreTokens() || !(timeSeparator = st.nextToken()).equals("T") && !timeSeparator.equals(" ")) {
                calendar.set(11, 0);
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int hour = Integer.parseInt(st.nextToken());
            calendar.set(11, hour);
            if (!DateParser.check(st, ":") || !st.hasMoreTokens()) {
                calendar.set(12, 0);
                calendar.set(13, 0);
                calendar.set(14, 0);
                return calendar;
            }
            int minutes = Integer.parseInt(st.nextToken());
            calendar.set(12, minutes);
            if (!st.hasMoreTokens()) {
                return calendar;
            }
            String tok = st.nextToken();
            if (tok.equals(":")) {
                if (!st.hasMoreTokens()) throw new InvalidDateException("No seconds specified");
                int secondes = Integer.parseInt(st.nextToken());
                calendar.set(13, secondes);
                if (!st.hasMoreTokens()) {
                    return calendar;
                }
                tok = st.nextToken();
                if (tok.equals(".") || tok.equals(",")) {
                    String nt = st.nextToken();
                    while (nt.length() < 3) {
                        nt = String.valueOf(nt) + "0";
                    }
                    nt = nt.substring(0, 3);
                    int millisec = Integer.parseInt(nt);
                    calendar.set(14, millisec);
                    if (!st.hasMoreTokens()) {
                        return calendar;
                    }
                    tok = st.nextToken();
                } else {
                    calendar.set(14, 0);
                }
            } else {
                calendar.set(13, 0);
                calendar.set(14, 0);
            }
            if (tok.equals("Z")) {
                calendar.setTimeZone(TimeZone.getTimeZone("GMT"));
                return calendar;
            } else {
                int tzmin;
                int tzhour;
                if (!tok.equals("+") && !tok.equals("-")) {
                    throw new InvalidDateException("only Z, + or - allowed");
                }
                boolean plus = tok.equals("+");
                if (!st.hasMoreTokens()) {
                    throw new InvalidDateException("Missing timezone hour field");
                }
                String tzToken = st.nextToken();
                if (tzToken.length() > 2) {
                    tzhour = Integer.parseInt(tzToken.substring(0, 2));
                    tzmin = Integer.parseInt(tzToken.substring(2));
                } else {
                    tzhour = Integer.parseInt(tzToken);
                    tzmin = 0;
                    if (!DateParser.check(st, ":") || !st.hasMoreTokens()) throw new InvalidDateException("Missing timezone minute field");
                    tzmin = Integer.parseInt(st.nextToken());
                }
                SimpleTimeZone tz = plus ? new SimpleTimeZone(3600000 * tzhour + 60000 * tzmin, "+" + 100 * tzhour + tzmin) : new SimpleTimeZone(-3600000 * tzhour - 60000 * tzmin, "-" + 100 * tzhour + tzmin);
                calendar.setTimeZone(tz);
            }
            return calendar;
        }
        catch (NumberFormatException ex) {
            throw new InvalidDateException("[" + ex.getMessage() + "] is not an integer");
        }
    }

    public static Date parse(Calendar calendar, String isodate) throws InvalidDateException {
        Calendar resultCalendar = DateParser.getCalendar(calendar, isodate);
        return resultCalendar.getTime();
    }

    public static Date parse(String isodate) throws InvalidDateException {
        Calendar calendar = DateParser.getCalendar(new GregorianCalendar(), isodate);
        return calendar.getTime();
    }

    public static Date parseUTC(String isodate) throws InvalidDateException {
        Calendar calendar = DateParser.getCalendar(new GregorianCalendar(TimeZone.getTimeZone("UTC")), isodate);
        return calendar.getTime();
    }

    private static String twoDigit(int i) {
        if (i >= 0 && i < 10) {
            return "0" + String.valueOf(i);
        }
        return String.valueOf(i);
    }

    public static String getIsoDate(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer(DateParser.getIsoDateNoHours(date));
        buffer.append("T");
        buffer.append(DateParser.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(13)));
        buffer.append(".");
        buffer.append(DateParser.twoDigit(calendar.get(14) / 10));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String getIsoDateNoMillis(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer(DateParser.getIsoDateNoHours(date));
        buffer.append("T");
        buffer.append(DateParser.twoDigit(calendar.get(11)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(12)));
        buffer.append(":");
        buffer.append(DateParser.twoDigit(calendar.get(13)));
        buffer.append("Z");
        return buffer.toString();
    }

    public static String getIsoDateNoHours(Date date) {
        GregorianCalendar calendar = new GregorianCalendar();
        calendar.setTime(date);
        StringBuffer buffer = new StringBuffer();
        buffer.append(calendar.get(1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(2) + 1));
        buffer.append("-");
        buffer.append(DateParser.twoDigit(calendar.get(5)));
        return buffer.toString();
    }

    public static void test(String isodate) {
        System.out.println("----------------------------------");
        try {
            Date date = DateParser.parse(isodate);
            System.out.println(">> " + isodate);
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
            System.out.println(">> " + DateParser.getIsoDate(date));
        }
        catch (InvalidDateException ex) {
            System.err.println(String.valueOf(isodate) + " is invalid");
            System.err.println(ex.getMessage());
        }
        System.out.println("----------------------------------");
    }

    public static void test(Date date) {
        String isodate = null;
        System.out.println("----------------------------------");
        try {
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
            isodate = DateParser.getIsoDate(date);
            System.out.println(">> " + isodate);
            date = DateParser.parse(isodate);
            System.out.println(">> " + date.toString() + " [" + date.getTime() + "]");
        }
        catch (InvalidDateException ex) {
            System.err.println(String.valueOf(isodate) + " is invalid");
            System.err.println(ex.getMessage());
        }
        System.out.println("----------------------------------");
    }

    public static void main(String[] args) {
        DateParser.test("1997-07-16T19:20:30.45-02:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20:30+01:00");
        DateParser.test("1997-07-16T19:20");
        DateParser.test("1997-07-16");
        DateParser.test("1997-07");
        DateParser.test("1997");
        DateParser.test(new Date());
    }
}

