/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.metering.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.concurrent.RunnableWithException;
import com.sap.sse.concurrent.RunnableWithResult;
import com.sap.sse.concurrent.RunnableWithResultAndException;
import com.sap.sse.metering.CPUMeter;
import com.sap.sse.metering.CPUMetrics;
import com.sap.sse.metering.CompositeCPUMetrics;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.function.Function;

public class CompositeCPUMetricsImpl
implements CompositeCPUMetrics {
    private ConcurrentMap<CPUMetrics, Boolean> componentCPUMetrics = new ConcurrentHashMap<CPUMetrics, Boolean>();
    private final CPUMeter localCPUMeter = CPUMeter.create();

    @Override
    public void add(CPUMetrics cpuMetrics) {
        this.componentCPUMetrics.put(cpuMetrics, true);
    }

    @Override
    public Map<String, Duration> getTotalCPUTimesByKey() {
        return this.getTimesByKey(CPUMetrics::getTotalCPUTimesByKey);
    }

    private Map<String, Duration> getTimesByKey(Function<CPUMetrics, Map<String, Duration>> timesMethod) {
        HashMap<String, Duration> result = new HashMap<String, Duration>();
        for (CPUMetrics componentMetric : this.getComponentMetrics()) {
            for (Map.Entry<String, Duration> e : timesMethod.apply(componentMetric).entrySet()) {
                result.merge(e.getKey(), e.getValue(), (sum, value) -> sum.plus(value));
            }
        }
        return result;
    }

    @Override
    public Map<String, Duration> getTotalCPUTimesInUserModeByKey() {
        return this.getTimesByKey(CPUMetrics::getTotalCPUTimesInUserModeByKey);
    }

    private Iterable<CPUMetrics> getComponentMetrics() {
        ArrayList<CPUMetrics> result = new ArrayList<CPUMetrics>(this.componentCPUMetrics.size() + 1);
        result.addAll(this.componentCPUMetrics.keySet());
        result.add(this.localCPUMeter);
        return result;
    }

    @Override
    public void runWithCPUMeter(Runnable runnable, String key) {
        this.localCPUMeter.runWithCPUMeter(runnable, key);
    }

    @Override
    public <T, E extends Throwable> T callWithCPUMeterWithException(RunnableWithResultAndException<T, E> callable, String key) throws E {
        return this.localCPUMeter.callWithCPUMeterWithException(callable, key);
    }

    @Override
    public <T> T callWithCPUMeter(RunnableWithResult<T> callable, String key) {
        return this.localCPUMeter.callWithCPUMeter(callable, key);
    }

    @Override
    public <E extends Exception> void runWithCPUMeter(RunnableWithException<E> runnableWithException, String key) throws E {
        this.localCPUMeter.runWithCPUMeter(runnableWithException, key);
    }
}

