/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.metering.impl;

import com.sap.sse.common.Duration;
import com.sap.sse.common.impl.MillisecondsDurationImpl;
import com.sap.sse.concurrent.RunnableWithException;
import com.sap.sse.concurrent.RunnableWithResult;
import com.sap.sse.concurrent.RunnableWithResultAndException;
import com.sap.sse.metering.CPUMeter;
import java.lang.management.ManagementFactory;
import java.lang.management.ThreadMXBean;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicLong;

public class CPUMeterImpl
implements CPUMeter {
    private static final String NULL = "___null___" + new Random().nextDouble();
    private static final ThreadMXBean threadMxBean = ManagementFactory.getThreadMXBean();
    private final ConcurrentMap<String, AtomicLong> totalCPUTimePerKeyInNanos = new ConcurrentHashMap<String, AtomicLong>();
    private final ConcurrentMap<String, AtomicLong> totalCPUTimePerKeyInUserModeInNanos = new ConcurrentHashMap<String, AtomicLong>();

    static {
        threadMxBean.setThreadCpuTimeEnabled(true);
    }

    private String escapeNull(String key) {
        return key == null ? NULL : key;
    }

    private String unescapeNull(String key) {
        return key == NULL ? null : key;
    }

    @Override
    public void runWithCPUMeter(Runnable runnable, String key) {
        this.callWithCPUMeter(() -> {
            runnable.run();
            return null;
        });
    }

    @Override
    public <T> T callWithCPUMeter(RunnableWithResult<T> callable, String key) {
        return this.callWithCPUMeterWithException(() -> {
            callable.run();
            return null;
        }, key);
    }

    @Override
    public <T, E extends Throwable> T callWithCPUMeterWithException(RunnableWithResultAndException<T, E> callable, String key) throws E {
        String nullEscapedKey = this.escapeNull(key);
        long cpuAtStartInNanos = threadMxBean.getCurrentThreadCpuTime();
        long cpuUserTimeAtStartInNanos = threadMxBean.getCurrentThreadUserTime();
        Object result = callable.run();
        this.totalCPUTimePerKeyInNanos.computeIfAbsent(nullEscapedKey, k -> new AtomicLong()).addAndGet(threadMxBean.getCurrentThreadCpuTime() - cpuAtStartInNanos);
        this.totalCPUTimePerKeyInUserModeInNanos.computeIfAbsent(nullEscapedKey, k -> new AtomicLong()).addAndGet(threadMxBean.getCurrentThreadUserTime() - cpuUserTimeAtStartInNanos);
        return (T)result;
    }

    @Override
    public <E extends Exception> void runWithCPUMeter(RunnableWithException<E> runnableWithException, String key) throws E {
        try {
            this.callWithCPUMeterWithException(() -> {
                runnableWithException.run();
                return null;
            }, key);
        }
        catch (Exception e) {
            Exception ex = e;
            throw ex;
        }
    }

    @Override
    public Duration getTotalCPUTime() {
        long nanosSum = 0L;
        for (Map.Entry e : this.totalCPUTimePerKeyInNanos.entrySet()) {
            nanosSum += ((AtomicLong)e.getValue()).longValue();
        }
        return new MillisecondsDurationImpl(nanosSum / 1000000L);
    }

    @Override
    public Duration getTotalCPUTimeInUserMode() {
        long nanosSum = 0L;
        for (Map.Entry e : this.totalCPUTimePerKeyInUserModeInNanos.entrySet()) {
            nanosSum += ((AtomicLong)e.getValue()).longValue();
        }
        return new MillisecondsDurationImpl(nanosSum / 1000000L);
    }

    @Override
    public Duration getTotalCPUTime(String key) {
        return new MillisecondsDurationImpl(this.totalCPUTimePerKeyInNanos.getOrDefault(this.escapeNull(key), new AtomicLong()).longValue() / 1000000L);
    }

    @Override
    public Duration getTotalCPUTimeInUserMode(String key) {
        return new MillisecondsDurationImpl(this.totalCPUTimePerKeyInUserModeInNanos.getOrDefault(this.escapeNull(key), new AtomicLong()).longValue() / 1000000L);
    }

    @Override
    public Map<String, Duration> getTotalCPUTimesByKey() {
        HashMap<String, Duration> result = new HashMap<String, Duration>();
        for (Map.Entry e : this.totalCPUTimePerKeyInNanos.entrySet()) {
            result.put(this.unescapeNull((String)e.getKey()), (Duration)new MillisecondsDurationImpl(((AtomicLong)e.getValue()).longValue() / 1000000L));
        }
        return result;
    }

    @Override
    public Map<String, Duration> getTotalCPUTimesInUserModeByKey() {
        HashMap<String, Duration> result = new HashMap<String, Duration>();
        for (Map.Entry e : this.totalCPUTimePerKeyInUserModeInNanos.entrySet()) {
            result.put(this.unescapeNull((String)e.getKey()), (Duration)new MillisecondsDurationImpl(((AtomicLong)e.getValue()).longValue() / 1000000L));
        }
        return result;
    }
}

