/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.i18n.impl;

import com.sap.sse.i18n.ResourceBundleStringMessages;
import java.nio.charset.StandardCharsets;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ResourceBundleStringMessagesImpl
implements ResourceBundleStringMessages {
    private static final Locale DEFAULT_LOCALE = Locale.ENGLISH;
    private final String resourceBaseName;
    private final ClassLoader resourceClassLoader;
    private String encoding;
    private ResourceBundle result;
    private static final Pattern placeholderMatcher = Pattern.compile("\\{([0-9]+)\\}.*", 32);

    public ResourceBundleStringMessagesImpl(String resourceBaseName, ClassLoader resourceClassLoader, String encoding) {
        this.resourceBaseName = resourceBaseName;
        this.resourceClassLoader = resourceClassLoader;
        this.encoding = encoding;
    }

    public ResourceBundleStringMessagesImpl(String resourceBaseName, ClassLoader resourceClassLoader) {
        this.resourceBaseName = resourceBaseName;
        this.resourceClassLoader = resourceClassLoader;
        this.encoding = StandardCharsets.ISO_8859_1.name();
    }

    @Override
    public String get(Locale locale, String messageKey) {
        return this.get(locale, messageKey, new String[0]);
    }

    @Override
    public String get(Locale locale, String messageKey, String ... parameters) {
        String message;
        ResourceBundle bundle = this.getResourceBundle(locale) == null ? this.getResourceBundle(DEFAULT_LOCALE) : this.getResourceBundle(locale);
        try {
            message = bundle.getString(messageKey);
        }
        catch (MissingResourceException e) {
            message = this.getResourceBundle(DEFAULT_LOCALE).getString(messageKey);
        }
        return this.get(message, parameters);
    }

    String get(String message, String ... parameters) {
        StringBuilder result = new StringBuilder();
        boolean withinQuotedArea = false;
        int i = 0;
        while (i < message.length()) {
            if (this.isSingleQuote(message, i) || withinQuotedArea && message.charAt(i) == '\'') {
                withinQuotedArea = !withinQuotedArea;
            } else if (this.isDoubleQuote(message, i)) {
                result.append('\'');
                ++i;
            } else if (withinQuotedArea) {
                result.append(message.charAt(i));
            } else {
                int paramNumber = this.isParameterPlaceholder(message, i);
                if (paramNumber != -1) {
                    result.append(parameters[paramNumber]);
                    i += ("" + paramNumber).length() + 1;
                } else {
                    result.append(message.charAt(i));
                }
            }
            ++i;
        }
        return result.toString();
    }

    private boolean isDoubleQuote(String message, int i) {
        return i < message.length() - 1 && message.charAt(i) == '\'' && message.charAt(i + 1) == '\'';
    }

    private int isParameterPlaceholder(String message, int i) {
        Matcher matcher = placeholderMatcher.matcher(message.substring(i));
        int result = matcher.matches() ? Integer.valueOf(matcher.group(1)) : -1;
        return result;
    }

    private boolean isSingleQuote(String message, int i) {
        return i < message.length() && message.charAt(i) == '\'' && (i == message.length() - 1 || message.charAt(i + 1) != '\'');
    }

    private ResourceBundle getResourceBundle(Locale locale) {
        ResourceBundle.Control controller = ResourceBundleStringMessages.Util.createControl(this.encoding);
        try {
            this.result = this.resourceClassLoader != null ? ResourceBundle.getBundle(this.resourceBaseName, locale, this.resourceClassLoader, controller) : ResourceBundle.getBundle(this.resourceBaseName, locale, controller);
        }
        catch (MissingResourceException e) {
            return this.getResourceBundle(Locale.getDefault());
        }
        return this.result;
    }

    @Override
    public String getResourceBaseName() {
        return this.resourceBaseName;
    }
}

