/*
 * Decompiled with CFR 0.152.
 */
package com.sap.sse.classloading;

import com.sap.sse.shared.classloading.ClassLoaderRegistry;
import com.sap.sse.shared.classloading.ClassLoaderSupplier;
import com.sap.sse.util.ServiceTrackerFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTrackerCustomizerForClassLoaderSupplierRegistrations<C extends ClassLoaderSupplier>
implements ServiceTrackerCustomizer<C, C> {
    private final BundleContext context;
    private ClassLoaderRegistry classLoaderRegistry;

    public static <C extends ClassLoaderSupplier> ServiceTracker<C, C> createClassLoaderSupplierServiceTracker(BundleContext context, Class<C> clazz, ClassLoaderRegistry classLoaderRegistry) {
        ServiceTrackerCustomizerForClassLoaderSupplierRegistrations<C> serviceTrackerCustomizer = new ServiceTrackerCustomizerForClassLoaderSupplierRegistrations<C>(context, classLoaderRegistry);
        ServiceTracker<C, C> serviceTracker = ServiceTrackerFactory.createAndOpen(context, clazz, serviceTrackerCustomizer);
        ServiceReference[] serviceReferences = serviceTracker.getServiceReferences();
        if (serviceReferences != null) {
            ServiceReference[] serviceReferenceArray = serviceReferences;
            int n = serviceReferences.length;
            int n2 = 0;
            while (n2 < n) {
                ServiceReference mdiClassLoaderService = serviceReferenceArray[n2];
                serviceTrackerCustomizer.addingService((ServiceReference<C>)mdiClassLoaderService);
                ++n2;
            }
        }
        return serviceTracker;
    }

    public ServiceTrackerCustomizerForClassLoaderSupplierRegistrations(BundleContext context, ClassLoaderRegistry classLoaderRegistry) {
        this.context = context;
        this.classLoaderRegistry = classLoaderRegistry;
    }

    public C addingService(ServiceReference<C> reference) {
        ClassLoaderSupplier service = (ClassLoaderSupplier)this.context.getService(reference);
        this.classLoaderRegistry.addClassLoader(service.getClassLoader());
        return (C)service;
    }

    public void modifiedService(ServiceReference<C> reference, C service) {
    }

    public void removedService(ServiceReference<C> reference, C service) {
        this.classLoaderRegistry.removeClassLoader(service.getClassLoader());
    }
}

