/*
 * Decompiled with CFR 0.152.
 */
package org.moxieapps.gwt.highcharts.client;

import com.google.gwt.core.client.JavaScriptObject;
import com.google.gwt.core.client.JsArray;
import com.google.gwt.core.client.JsonUtils;
import com.google.gwt.dom.client.Document;
import com.google.gwt.json.client.JSONArray;
import com.google.gwt.json.client.JSONNull;
import com.google.gwt.json.client.JSONNumber;
import com.google.gwt.json.client.JSONObject;
import com.google.gwt.json.client.JSONString;
import com.google.gwt.json.client.JSONValue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import org.moxieapps.gwt.highcharts.client.Animation;
import org.moxieapps.gwt.highcharts.client.BaseChart;
import org.moxieapps.gwt.highcharts.client.Chart;
import org.moxieapps.gwt.highcharts.client.Configurable;
import org.moxieapps.gwt.highcharts.client.Point;
import org.moxieapps.gwt.highcharts.client.ToolTip;
import org.moxieapps.gwt.highcharts.client.plotOptions.PlotOptions;

public class Series
extends Configurable<Series> {
    BaseChart chart;
    private String id;
    private ToolTip toolTip;
    private Type type;
    private PlotOptions plotOptions;
    private ArrayList<Point> points = new ArrayList();
    boolean rendered = false;

    protected Series(BaseChart chart) {
        this.chart = chart;
        this.id = Document.get().createUniqueId();
        this.setOption("id", this.id);
    }

    public Series setColorByPoint(boolean colorByPoint) {
        return (Series)this.setOption("colorByPoint", colorByPoint);
    }

    public Series setIndex(Number index) {
        return (Series)this.setOption("index", index);
    }

    public Series setLegendIndex(Number legendIndex) {
        return (Series)this.setOption("legendIndex", legendIndex);
    }

    public Series setName(String name) {
        return (Series)this.setOption("name", name);
    }

    public String getName() {
        return ((JSONString)this.getOptions().get("name")).stringValue() != null ? ((JSONString)this.getOptions().get("name")).stringValue() : null;
    }

    public Series setStack(String stack) {
        return (Series)this.setOption("stack", stack);
    }

    public Series setStack(Number stack) {
        return (Series)this.setOption("stack", stack);
    }

    public Series setToolTip(ToolTip toolTip) {
        this.toolTip = toolTip;
        return (Series)this.setOption("/tooltip", toolTip != null ? toolTip.getOptions() : null);
    }

    public Series setType(Type type) {
        this.type = type;
        return (Series)this.setOption("type", type != null ? type.toString() : null);
    }

    Type getType() {
        if (this.type != null) {
            return this.type;
        }
        return this.chart.defaultSeriesType;
    }

    public Series setXAxis(Number xAxis) {
        return (Series)this.setOption("xAxis", xAxis);
    }

    public Series setYAxis(Number yAxis) {
        return (Series)this.setOption("yAxis", yAxis);
    }

    public Series setPlotOptions(PlotOptions plotOptions) {
        this.plotOptions = plotOptions;
        if (plotOptions == null) {
            return this;
        }
        JSONObject plotOptionsJSON = plotOptions.getOptions();
        if (plotOptionsJSON != null) {
            for (String key : plotOptionsJSON.keySet()) {
                this.setOption(key, plotOptionsJSON.get(key));
            }
        }
        return this;
    }

    PlotOptions getPlotOptions() {
        return this.plotOptions;
    }

    public Series addPoint(Number y) {
        return this.addPoint(new Point(y));
    }

    public Series addPoint(Number x, String title, String text) {
        return this.addPoint(new Point(x, title, text));
    }

    public Series addPoint(Number y, boolean redraw, boolean shift, boolean animation) {
        return this.addPoint(new Point(y), redraw, shift, animation);
    }

    public Series addPoint(Number y, boolean redraw, boolean shift, Animation animation) {
        return this.addPoint(new Point(y), redraw, shift, animation);
    }

    public Series addPoint(Number x, Number y) {
        return this.addPoint(new Point(x, y));
    }

    public Series addPoint(Number x, Number low, Number high) {
        return this.addPoint(new Point(x, low, high));
    }

    public Series addPoint(Number x, Number open, Number high, Number low, Number close) {
        return this.addPoint(new Point(x, open, high, low, close));
    }

    public Series addPoint(Number x, Number y, boolean redraw, boolean shift, boolean animation) {
        return this.addPoint(new Point(x, y), redraw, shift, animation);
    }

    public Series addPoint(Number x, Number y, boolean redraw, boolean shift, Animation animation) {
        return this.addPoint(new Point(x, y), redraw, shift, animation);
    }

    public Series addPoint(Number x, Number open, Number high, Number low, Number close, boolean redraw, boolean shift, Animation animation) {
        return this.addPoint(new Point(x, open, high, low, close), redraw, shift, animation);
    }

    public Series addPoint(Point point) {
        return this.addPoint(point, true, false, true);
    }

    public Series addPoint(Point point, boolean redraw, boolean shift, boolean animation) {
        return this.addPoint(point, redraw, shift, animation ? new Animation() : null);
    }

    public Series addPoint(Point point, boolean redraw, boolean shift, Animation animation) {
        JavaScriptObject nativeSeries;
        if (!this.isRendered() || this.chart.isPersistent()) {
            if (shift && this.points.size() > 0) {
                this.points.remove(0);
            }
            this.points.add(point);
        }
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            if (animation == null || animation.getOptions() == null) {
                boolean animationFlag;
                boolean bl = animationFlag = animation != null;
                if (point == null || point.isSingleValue() && point.getY() == null) {
                    Series.nativeAddPoint(nativeSeries, null, redraw, shift, animationFlag);
                } else if (point.isSingleValue() && !this.chart.isPersistent() && !point.hasNativeProperties()) {
                    Series.nativeAddPoint(nativeSeries, point.getY().doubleValue(), redraw, shift, animationFlag);
                } else {
                    Series.nativeAddPoint(nativeSeries, this.convertPointToJavaScriptObject(point), redraw, shift, animationFlag);
                }
            } else {
                JavaScriptObject animationOptions = animation.getOptions().getJavaScriptObject();
                if (point == null || point.isSingleValue() && point.getY() == null) {
                    Series.nativeAddPoint(nativeSeries, null, redraw, shift, animationOptions);
                } else if (point.isSingleValue() && !this.chart.isPersistent() && !point.hasNativeProperties()) {
                    Series.nativeAddPoint(nativeSeries, point.getY().doubleValue(), redraw, shift, animationOptions);
                } else {
                    Series.nativeAddPoint(nativeSeries, this.convertPointToJavaScriptObject(point), redraw, shift, animationOptions);
                }
            }
        }
        return this;
    }

    private JavaScriptObject convertPointToJavaScriptObject(Point point) {
        JSONObject options = point.getOptions() != null ? point.getOptions() : new JSONObject();
        Chart.addPointScalarValues(point, options, this.getType());
        if (point.hasNativeProperties()) {
            Point.addPointNativeProperties(point, options);
        }
        if (this.chart != null) {
            this.chart.addPointId(point, options);
        }
        return options.getJavaScriptObject();
    }

    private JavaScriptObject convertSeriesToJavaScriptObject(Series series) {
        JSONObject options = series.getOptions() != null ? series.getOptions() : new JSONObject();
        return options.getJavaScriptObject();
    }

    public Series setPoints(Number[] yValues) {
        return this.setPoints(yValues, true);
    }

    public Series setPoints(Number[] yValues, boolean redraw) {
        JavaScriptObject nativeSeries;
        this.points.clear();
        if (!this.isRendered() || this.chart.isPersistent()) {
            Number[] numberArray = yValues;
            int n = yValues.length;
            int n2 = 0;
            while (n2 < n) {
                Number yValue = numberArray[n2];
                this.addPoint(yValue);
                ++n2;
            }
        }
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            int pointsLength = yValues.length;
            while (i < pointsLength) {
                if (yValues[i] != null) {
                    jsonArray.set(i, (JSONValue)new JSONNumber(yValues[i].doubleValue()));
                } else {
                    jsonArray.set(i, (JSONValue)JSONNull.getInstance());
                }
                ++i;
            }
            Series.nativeSetData(nativeSeries, jsonArray.getJavaScriptObject(), redraw);
        }
        return this;
    }

    public Series setPoints(Number[][] values) {
        return this.setPoints(values, true);
    }

    public Series setPoints(Number[][] values, boolean redraw) {
        JavaScriptObject nativeSeries;
        this.points.clear();
        if (!this.isRendered() || this.chart.isPersistent()) {
            Number[][] numberArray = values;
            int n = values.length;
            int n2 = 0;
            while (n2 < n) {
                Number[] xyValue = numberArray[n2];
                if (xyValue.length == 5) {
                    this.addPoint(xyValue[0], xyValue[1], xyValue[2], xyValue[3], xyValue[4]);
                } else if (xyValue.length == 3) {
                    this.addPoint(xyValue[0], xyValue[1], xyValue[2]);
                } else {
                    this.addPoint(xyValue[0], xyValue[1]);
                }
                ++n2;
            }
        }
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            int pointsLength = values.length;
            while (i < pointsLength) {
                JSONNull jsonValue;
                Number[] point = values[i];
                if (point == null) {
                    jsonValue = JSONNull.getInstance();
                } else if (point.length > 0) {
                    JSONArray pointArray = new JSONArray();
                    int j = 0;
                    while (j < point.length) {
                        pointArray.set(j, BaseChart.convertNumberToJSONValue(point[j]));
                        ++j;
                    }
                    jsonValue = pointArray;
                } else {
                    jsonValue = BaseChart.convertNumberToJSONValue(point[0]);
                }
                jsonArray.set(i, (JSONValue)jsonValue);
                ++i;
            }
            Series.nativeSetData(nativeSeries, jsonArray.getJavaScriptObject(), redraw);
        }
        return this;
    }

    public Series setPoints(Point[] points) {
        return this.setPoints(points, true);
    }

    public Series setPoints(Point[] points, boolean redraw) {
        JavaScriptObject nativeSeries;
        this.points.clear();
        if (!this.isRendered() || this.chart.isPersistent()) {
            Collections.addAll(this.points, points);
        }
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            JSONArray jsonArray = new JSONArray();
            int i = 0;
            int pointsLength = points.length;
            while (i < pointsLength) {
                jsonArray.set(i, this.chart.convertPointToJSON(points[i], this.getType()));
                ++i;
            }
            Series.nativeSetData(nativeSeries, jsonArray.getJavaScriptObject(), redraw);
        }
        return this;
    }

    public Series setPoints(JSONArray points, boolean redraw) {
        JavaScriptObject nativeSeries = this.chart.get(this.id);
        if (nativeSeries != null) {
            Series.nativeSetData(nativeSeries, points.getJavaScriptObject(), redraw);
        }
        return this;
    }

    public Point[] getPoints() {
        ArrayList<Point> convertedPoints = this.points;
        if (this.isRendered() && !this.chart.isPersistent()) {
            convertedPoints = new ArrayList();
            JavaScriptObject nativeSeries = this.chart.get(this.id);
            if (nativeSeries != null) {
                JsArray<JavaScriptObject> nativePoints = Series.nativeGetData(nativeSeries);
                int i = 0;
                while (i < nativePoints.length()) {
                    JavaScriptObject nativePoint = nativePoints.get(i);
                    convertedPoints.add(new Point(nativePoint));
                    ++i;
                }
            }
        }
        return convertedPoints.toArray(new Point[convertedPoints.size()]);
    }

    public Series removePoint(Point point) {
        return this.removePoint(point, true, true);
    }

    public Series removePoint(Point point, boolean redraw, boolean animation) {
        return this.removePoint(point, redraw, animation ? new Animation() : null);
    }

    public Series removePoint(Point point, boolean redraw, Animation animation) {
        String id = point.getId(false);
        point.remove(redraw, animation);
        if (id != null && this.points != null) {
            Iterator<Point> iterator = this.points.iterator();
            while (iterator.hasNext()) {
                Point existingPoint = iterator.next();
                if (!id.equals(existingPoint.getId(false))) continue;
                iterator.remove();
            }
        }
        return this;
    }

    public boolean remove() {
        return this.chart.removeSeries(this);
    }

    public Series show() {
        JavaScriptObject nativeSeries;
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            Series.nativeShow(nativeSeries);
        }
        return this;
    }

    public Series hide() {
        JavaScriptObject nativeSeries;
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            Series.nativeHide(nativeSeries);
        }
        return this;
    }

    public Series setVisible(boolean visible) {
        return this.setVisible(visible, true);
    }

    public Series setVisible(boolean visible, boolean redraw) {
        JavaScriptObject nativeSeries;
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            Series.nativeSetVisible(nativeSeries, visible, redraw);
        }
        return this;
    }

    public Series select(boolean select) {
        JavaScriptObject nativeSeries;
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            Series.nativeSelect(nativeSeries, select);
        }
        return this;
    }

    public Series selectToggle() {
        JavaScriptObject nativeSeries;
        if (this.isRendered() && (nativeSeries = this.chart.get(this.id)) != null) {
            Series.nativeSelectToggle(nativeSeries);
        }
        return this;
    }

    public boolean isVisible() {
        JavaScriptObject nativeSeries = this.getNativeSeries();
        return nativeSeries != null && Series.nativeIsVisible(nativeSeries);
    }

    public JavaScriptObject getNativeSeries() {
        if (this.isRendered()) {
            return this.chart.get(this.id);
        }
        return null;
    }

    public String getId() {
        return this.id;
    }

    void clearInternalPointsList() {
        if (!this.chart.isPersistent()) {
            this.points.clear();
        }
    }

    void setRendered(boolean flag) {
        this.rendered = flag;
    }

    private boolean isRendered() {
        return this.rendered;
    }

    public Series update(Series seriesOptions) {
        return this.update(seriesOptions, true);
    }

    public Series update(Series seriesOptions, boolean redraw) {
        JavaScriptObject nativeSeries = this.getNativeSeries();
        if (nativeSeries != null) {
            Series.nativeUpdateSeries(nativeSeries, this.convertSeriesToJavaScriptObject(seriesOptions), redraw);
        }
        return this;
    }

    private static native JavaScriptObject nativeAddPoint(JavaScriptObject var0, JavaScriptObject var1, boolean var2, boolean var3, JavaScriptObject var4);

    private static native JavaScriptObject nativeAddPoint(JavaScriptObject var0, JavaScriptObject var1, boolean var2, boolean var3, boolean var4);

    private static native JavaScriptObject nativeAddPoint(JavaScriptObject var0, double var1, boolean var3, boolean var4, JavaScriptObject var5);

    private static native JavaScriptObject nativeAddPoint(JavaScriptObject var0, double var1, boolean var3, boolean var4, boolean var5);

    private static native void nativeSetData(JavaScriptObject var0, JavaScriptObject var1, boolean var2);

    private static native void nativeShow(JavaScriptObject var0);

    private static native void nativeHide(JavaScriptObject var0);

    private static native void nativeSetVisible(JavaScriptObject var0, boolean var1, boolean var2);

    private static native void nativeSelect(JavaScriptObject var0, boolean var1);

    private static native void nativeSelectToggle(JavaScriptObject var0);

    private static native JsArray<JavaScriptObject> nativeGetData(JavaScriptObject var0);

    private static native boolean nativeIsVisible(JavaScriptObject var0);

    private static native void nativeUpdateSeries(JavaScriptObject var0, JavaScriptObject var1, boolean var2);

    public void updateThreshold(String threshold) {
        Series.updateThresHoldNative(this.getNativeSeries(), threshold);
    }

    public void updateSeriesFillColor(String fillColor) {
        JavaScriptObject fillColorObject = JsonUtils.safeEval((String)fillColor);
        Series.updateFillColorNative(this.getNativeSeries(), fillColorObject);
    }

    public static native void updateThresHoldNative(JavaScriptObject var0, String var1);

    public static native void updateFillColorNative(JavaScriptObject var0, JavaScriptObject var1);

    public static enum Type {
        AREA("area"),
        AREA_RANGE("arearange"),
        AREA_SPLINE("areaspline"),
        AREA_SPLINE_RANGE("areasplinerange"),
        BAR("bar"),
        BOXPLOT("boxplot"),
        BUBBLE("bubble"),
        COLUMN("column"),
        COLUMN_RANGE("columnrange"),
        ERRORBAR("errorbar"),
        FLAGS("flags"),
        FUNNEL("funnel"),
        HEATMAP("heatmap"),
        GAUGE("gauge"),
        LINE("line"),
        PIE("pie"),
        PYRAMID("pyramid"),
        SCATTER("scatter"),
        SOLID_GAUGE("solidgauge"),
        SPLINE("spline"),
        TREEMAP("treemap"),
        WATERFALL("waterfall"),
        OHLC("ohlc"),
        CANDLESTICK("candlestick");

        private final String optionName;

        private Type(String optionName) {
            this.optionName = optionName;
        }

        public String toString() {
            return this.optionName;
        }
    }
}

